/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetpreprocessor;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.datasetpreprocessor.AbstractScriptedDataSetPreProcessorConfigurator;
import adams.ml.dl4j.datasetpreprocessor.DataSetPreProcessorConfigurator;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class DataSetPreProcessorWithScriptedConfiguration
extends AbstractScriptedDataSetPreProcessorConfigurator
implements DataSetPreProcessor {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient DataSetPreProcessorConfigurator m_DataSetPreProcessorConfiguratorObject;
    protected DataSetPreProcessor m_DataSetPreProcessor;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta-preprocessor that uses any scripting handler for generating the preprocessor in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(DataSetPreProcessorConfigurator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_DataSetPreProcessorConfiguratorObject = (DataSetPreProcessorConfigurator)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_DataSetPreProcessorConfiguratorObject = null;
    }

    @Override
    public DataSetPreProcessor configureDataSetPreProcessor() {
        String msg;
        if (this.m_DataSetPreProcessorConfiguratorObject == null && (msg = this.check()) != null) {
            throw new IllegalStateException(msg);
        }
        if (this.m_DataSetPreProcessorConfiguratorObject != null) {
            return this.m_DataSetPreProcessorConfiguratorObject.configureDataSetPreProcessor();
        }
        throw new IllegalStateException("No dataset iterator generator available!");
    }

    protected synchronized DataSetPreProcessor getDataSetPreProcessor() {
        if (this.m_DataSetPreProcessor == null) {
            this.m_DataSetPreProcessor = this.configureDataSetPreProcessor();
        }
        return this.m_DataSetPreProcessor;
    }

    public void preProcess(DataSet toPreProcess) {
        this.getDataSetPreProcessor().preProcess(toPreProcess);
    }
}

