/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetpreprocessor;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.datasetpreprocessor.AbstractScriptedDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class ScriptedDataSetPreProcessor
extends AbstractScriptedDataSetPreProcessor {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient DataSetPreProcessor m_DataSetPreProcessorObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta dataset preprocessor that uses any scripting handler for managing the dataset preprocessor in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(DataSetPreProcessor.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_DataSetPreProcessorObject = (DataSetPreProcessor)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_DataSetPreProcessorObject = null;
    }

    protected synchronized DataSetPreProcessor getDataSetPreProcessor() {
        if (this.m_DataSetPreProcessorObject != null) {
            return this.m_DataSetPreProcessorObject;
        }
        throw new IllegalStateException("No input split script loaded!");
    }

    public void preProcess(DataSet toPreProcess) {
        this.getDataSetPreProcessor().preProcess(toPreProcess);
    }
}

