/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.inputsplit;

import adams.core.Randomizable;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.ml.dl4j.inputsplit.AbstractInputSplitConfigurator;
import java.util.Random;
import org.canova.api.split.FileSplit;
import org.canova.api.split.InputSplit;

public class FileSplitConfigurator
extends AbstractInputSplitConfigurator
implements Randomizable {
    private static final long serialVersionUID = -384107247374795362L;
    protected PlaceholderDirectory m_RootDir;
    protected BaseString[] m_AllowFormat;
    protected boolean m_Recursive;
    protected boolean m_Randomize;
    protected long m_Seed;

    public String globalInfo() {
        return "Configures a " + FileSplit.class.getName() + " instance.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("root-dir", "rootDir", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("allow-format", "allowFormat", (Object)new BaseString[0]);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("randomize", "randomize", (Object)false);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
    }

    public void setRootDir(PlaceholderDirectory value) {
        this.m_RootDir = value;
        this.reset();
    }

    public PlaceholderDirectory getRootDir() {
        return this.m_RootDir;
    }

    public String rootDirTipText() {
        return "The root directory to use.";
    }

    public void setAllowFormat(BaseString[] value) {
        this.m_AllowFormat = value;
        this.reset();
    }

    public BaseString[] getAllowFormat() {
        return this.m_AllowFormat;
    }

    public String allowFormatTipText() {
        return "The acceptable extensions (without dot); all if 0-length array.";
    }

    public void setRecursive(boolean value) {
        this.m_Recursive = value;
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Recursive;
    }

    public String recursiveTipText() {
        return "If enabled, files are listed recursively.";
    }

    public void setRandomize(boolean value) {
        this.m_Randomize = value;
        this.reset();
    }

    public boolean getRandomize() {
        return this.m_Randomize;
    }

    public String randomizeTipText() {
        return "If enabled, randomization is used (automatically uses recursion).";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value to use for randomization.";
    }

    @Override
    protected InputSplit doConfigureInputSplit() {
        if (this.m_Randomize) {
            return new FileSplit(this.m_RootDir.getAbsoluteFile(), this.m_AllowFormat.length > 0 ? BaseObject.toStringArray((BaseObject[])this.m_AllowFormat) : null, new Random(this.m_Seed));
        }
        return new FileSplit(this.m_RootDir.getAbsoluteFile(), this.m_AllowFormat.length > 0 ? BaseObject.toStringArray((BaseObject[])this.m_AllowFormat) : null, this.m_Recursive);
    }
}

