/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.inputsplit;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.inputsplit.AbstractScriptedInputSplitConfigurator;
import adams.ml.dl4j.inputsplit.InputSplitConfigurator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.canova.api.split.InputSplit;

public class InputSplitWithScriptedConfiguration
extends AbstractScriptedInputSplitConfigurator
implements InputSplit {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient InputSplitConfigurator m_InputSplitConfiguratorObject;
    protected InputSplit m_InputSplit;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A sink action that uses any scripting handler for generating the input split in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(InputSplitConfigurator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_InputSplitConfiguratorObject = (InputSplitConfigurator)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_InputSplitConfiguratorObject = null;
    }

    @Override
    public InputSplit configureInputSplit() {
        String msg;
        if (this.m_InputSplitConfiguratorObject == null && (msg = this.check()) != null) {
            throw new IllegalStateException(msg);
        }
        if (this.m_InputSplitConfiguratorObject != null) {
            return this.m_InputSplitConfiguratorObject.configureInputSplit();
        }
        throw new IllegalStateException("No input split generator available!");
    }

    protected synchronized InputSplit getInputSplit() {
        if (this.m_InputSplit == null) {
            this.m_InputSplit = this.configureInputSplit();
        }
        return this.m_InputSplit;
    }

    public long length() {
        return this.getInputSplit().length();
    }

    public URI[] locations() {
        return this.getInputSplit().locations();
    }

    public void write(DataOutput out) throws IOException {
        this.getInputSplit().write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.getInputSplit().readFields(in);
    }

    public double toDouble() {
        return this.getInputSplit().toDouble();
    }

    public float toFloat() {
        return this.getInputSplit().toFloat();
    }

    public int toInt() {
        return this.getInputSplit().toInt();
    }

    public long toLong() {
        return this.getInputSplit().toLong();
    }
}

