/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.ml.dl4j.recordreader.AbstractRecordReaderConfigurator;
import java.util.Arrays;
import org.canova.api.records.reader.RecordReader;
import org.canova.image.recordreader.ImageRecordReader;

public class ImageRecordReaderConfigurator
extends AbstractRecordReaderConfigurator {
    private static final long serialVersionUID = 8914456080710417165L;
    protected int m_Width;
    protected int m_Height;
    protected int m_Channels;
    protected boolean m_AppendLabel;
    protected BaseString[] m_Labels;

    public String globalInfo() {
        return "Configures a " + ImageRecordReader.class.getName() + " instance.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)64, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)64, (Number)1, null);
        this.m_OptionManager.add("channels", "channels", (Object)3, (Number)1, null);
        this.m_OptionManager.add("append-label", "appendLabel", (Object)false);
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the images.";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the images.";
    }

    public void setChannels(int value) {
        if (this.getOptionManager().isValid("channels", (Number)value)) {
            this.m_Channels = value;
            this.reset();
        }
    }

    public int getChannels() {
        return this.m_Channels;
    }

    public String channelsTipText() {
        return "The number of channels.";
    }

    public void setAppendLabel(boolean value) {
        this.m_AppendLabel = value;
        this.reset();
    }

    public boolean getAppendLabel() {
        return this.m_AppendLabel;
    }

    public String appendLabelTipText() {
        return "Whether to append the label.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    @Override
    protected RecordReader doConfigureRecordReader() {
        return new ImageRecordReader(this.m_Width, this.m_Height, this.m_Channels, this.m_AppendLabel, Arrays.asList(BaseObject.toStringArray((BaseObject[])this.m_Labels)));
    }
}

