/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.recordreader.AbstractScriptedRecordReaderConfigurator;
import adams.ml.dl4j.recordreader.RecordReaderConfigurator;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.canova.api.conf.Configuration;
import org.canova.api.records.listener.RecordListener;
import org.canova.api.records.reader.RecordReader;
import org.canova.api.split.InputSplit;
import org.canova.api.writable.Writable;

public class RecordReaderWithScriptedConfiguration
extends AbstractScriptedRecordReaderConfigurator
implements RecordReader {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient RecordReaderConfigurator m_RecordReaderConfiguratorObject;
    protected RecordReader m_RecordReader;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta-iterator that uses any scripting handler for generating the iterator in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(RecordReaderConfigurator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_RecordReaderConfiguratorObject = (RecordReaderConfigurator)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_RecordReaderConfiguratorObject = null;
    }

    @Override
    public RecordReader configureRecordReader() {
        String msg;
        if (this.m_RecordReaderConfiguratorObject == null && (msg = this.check()) != null) {
            throw new IllegalStateException(msg);
        }
        if (this.m_RecordReaderConfiguratorObject != null) {
            return this.m_RecordReaderConfiguratorObject.configureRecordReader();
        }
        throw new IllegalStateException("No record reader generator available!");
    }

    protected synchronized RecordReader getRecordReader() {
        if (this.m_RecordReader == null) {
            this.m_RecordReader = this.configureRecordReader();
        }
        return this.m_RecordReader;
    }

    public void close() throws IOException {
        this.getRecordReader().close();
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.getRecordReader().initialize(split);
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.getRecordReader().initialize(conf, split);
    }

    public Collection<Writable> next() {
        return this.getRecordReader().next();
    }

    public boolean hasNext() {
        return this.getRecordReader().hasNext();
    }

    public List<String> getLabels() {
        return this.getRecordReader().getLabels();
    }

    public Collection<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.getRecordReader().record(uri, dataInputStream);
    }

    public Collection<RecordListener> getListeners() {
        return this.getRecordReader().getListeners();
    }

    public void setListeners(RecordListener ... recordListeners) {
        this.getRecordReader().setListeners(recordListeners);
    }

    public void setListeners(Collection<RecordListener> collection) {
        this.getRecordReader().setListeners(collection);
    }

    public void setConf(Configuration conf) {
        this.getRecordReader().setConf(conf);
    }

    public Configuration getConf() {
        return this.getRecordReader().getConf();
    }
}

