/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToJson;
import net.minidev.json.JSONAware;
import org.deeplearning4j.nn.api.Model;

public class DL4JModelToJson
extends AbstractConversion {
    private static final long serialVersionUID = -8817702395174849629L;

    public String globalInfo() {
        return "Converts a DL4J model into its JSON representation.";
    }

    public Class accepts() {
        return Model.class;
    }

    public Class generates() {
        return JSONAware.class;
    }

    protected Object doConvert() throws Exception {
        Model model = (Model)this.m_Input;
        String jsonStr = model.conf().toJson();
        StringToJson conv = new StringToJson();
        conv.setInput((Object)jsonStr);
        String msg = conv.convert();
        if (msg != null) {
            throw new Exception("Failed to parse JSON string from model!\n" + msg);
        }
        Object result = conv.getOutput();
        conv.cleanUp();
        return result;
    }
}

