/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -8817702395174849629L;

    public String globalInfo() {
        return "Converts a DL4J array into a spreadsheet.";
    }

    public Class accepts() {
        return INDArray.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        INDArray input = (INDArray)this.m_Input;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < input.columns(); ++i) {
            row.addCell("" + i).setContentAsString("col-" + (i + 1));
        }
        for (int j = 0; j < input.rows(); ++j) {
            row = result.addRow();
            for (i = 0; i < input.columns(); ++i) {
                row.addCell("" + i).setContent(Double.valueOf(input.getDouble(j, i)));
            }
        }
        return result;
    }
}

