/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JModelContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.ModelSerialization;
import java.io.File;
import org.deeplearning4j.nn.api.Model;

public abstract class AbstractDL4JModelReader
extends AbstractTransformer {
    private static final long serialVersionUID = -2949611378612429555L;
    protected boolean m_OutputOnlyModel;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-only-model", "outputOnlyModel", (Object)false);
    }

    public void setOutputOnlyModel(boolean value) {
        this.m_OutputOnlyModel = value;
        this.reset();
    }

    public boolean getOutputOnlyModel() {
        return this.m_OutputOnlyModel;
    }

    public String outputOnlyModelTipText() {
        return "If enabled, only the model will be output instead of a model container.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputOnlyModel", (boolean)this.m_OutputOnlyModel, (String)"only model");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        if (this.m_OutputOnlyModel) {
            return new Class[]{Object.class};
        }
        return new Class[]{DL4JModelContainer.class};
    }

    protected String doExecute() {
        String result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        try {
            Model model = ModelSerialization.read(file);
            if (this.m_OutputOnlyModel) {
                this.m_OutputToken = new Token((Object)model);
            } else {
                DL4JModelContainer cont = new DL4JModelContainer(model);
                this.m_OutputToken = new Token((Object)cont);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to deserialize model data from '" + file + "':", e);
        }
        return result;
    }
}

