/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.io.ModelFileHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.container.AbstractContainer;
import adams.flow.container.DL4JModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.ModelSerialization;
import java.io.File;
import java.util.Hashtable;
import org.nd4j.linalg.dataset.DataSet;

public abstract class AbstractProcessDL4JDatasetWithModel<T>
extends AbstractTransformer
implements ModelFileHandler {
    private static final long serialVersionUID = -5275241130624220000L;
    public static final String BACKUP_MODEL = "model";
    protected PlaceholderFile m_ModelFile;
    protected CallableActorReference m_ModelActor;
    protected T m_Model;
    protected boolean m_OnTheFly;
    protected boolean m_UseModelResetVariable;
    protected VariableName m_ModelResetVariable;
    protected boolean m_ResetModel;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_MODEL, "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
        this.m_OptionManager.add("use-model-reset-variable", "useModelResetVariable", (Object)false);
        this.m_OptionManager.add("model-reset-variable", "modelResetVariable", (Object)new VariableName());
    }

    protected void reset() {
        super.reset();
        this.m_Model = null;
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The model file to load (when not pointing to a directory).";
    }

    public void setModelActor(CallableActorReference value) {
        this.m_ModelActor = value;
        this.reset();
    }

    public CallableActorReference getModelActor() {
        return this.m_ModelActor;
    }

    public String modelActorTipText() {
        return "The callable actor to use for obtaining the model in case serialized model file points to a directory (can be a " + this.getModelContainerClass().getName() + " as well).";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public void setUseModelResetVariable(boolean value) {
        this.m_UseModelResetVariable = value;
        this.reset();
    }

    public boolean getUseModelResetVariable() {
        return this.m_UseModelResetVariable;
    }

    public String useModelResetVariableTipText() {
        return "If enabled, chnages to the specified variable are monitored in order to reset the model, eg when a storage model changed.";
    }

    public void setModelResetVariable(VariableName value) {
        this.m_ModelResetVariable = value;
        this.reset();
    }

    public VariableName getModelResetVariable() {
        return this.m_ModelResetVariable;
    }

    public String modelResetVariableTipText() {
        return "The variable to monitor for changes in order to reset the model, eg when a storage model changed.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)(this.m_ModelFile.isDirectory() ? this.m_ModelActor : this.m_ModelFile));
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"modelResetVariable", (Object)(this.m_UseModelResetVariable ? "reset: " + this.m_ModelResetVariable : ""));
        if (value != null) {
            result = result == null ? value : result + ", " + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    public abstract Class[] generates();

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_MODEL);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Model != null) {
            result.put(BACKUP_MODEL, this.m_Model);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_MODEL)) {
            this.m_Model = state.get(BACKUP_MODEL);
            state.remove(BACKUP_MODEL);
        }
        super.restoreState(state);
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (e.getName().equals(this.m_ModelResetVariable.getValue())) {
            this.m_ResetModel = true;
        }
    }

    protected Class getModelContainerClass() {
        return DL4JModelContainer.class;
    }

    protected T getModelFromContainer(AbstractContainer cont) {
        return (T)cont.getValue("Model");
    }

    protected String setUpModel() {
        String result;
        block9: {
            result = null;
            if (this.m_ModelFile.isDirectory()) {
                try {
                    MessageCollection errors = new MessageCollection();
                    Object obj = CallableActorHelper.getSetup(null, (CallableActorReference)this.m_ModelActor, (Actor)this, (MessageCollection)errors);
                    if (obj == null) {
                        if (!errors.isEmpty()) {
                            result = errors.toString();
                        }
                        break block9;
                    }
                    if (obj instanceof AbstractContainer) {
                        this.m_Model = this.getModelFromContainer((AbstractContainer)obj);
                        break block9;
                    }
                    this.m_Model = obj;
                }
                catch (Exception e) {
                    this.m_Model = null;
                    result = this.handleException("Failed to obtain model from callable actor '" + this.m_ModelActor + "': ", e);
                }
            } else {
                try {
                    this.m_Model = ModelSerialization.read((File)this.m_ModelFile);
                }
                catch (Exception e) {
                    this.m_Model = null;
                    result = this.handleException("Failed to load model from '" + this.m_ModelFile + "': ", e);
                }
            }
        }
        this.m_ResetModel = false;
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel();
        }
        return result;
    }

    protected abstract Token processDataset(DataSet var1) throws Exception;

    protected String doExecute() {
        String result = null;
        if ((this.m_OnTheFly && this.m_Model == null || this.m_ResetModel) && (result = this.setUpModel()) != null) {
            return result;
        }
        DataSet data = null;
        try {
            data = (DataSet)this.m_InputToken.getPayload();
            this.m_OutputToken = this.processDataset(data);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process dataset: " + data, e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Model = null;
    }
}

