/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.DL4JModelConfigurator;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.model.ModelConfigurator;
import java.util.Hashtable;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.listeners.ScoreIterationListener;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JTrainModel
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_MODEL = "model";
    protected CallableActorReference m_Model;
    protected Model m_ActualModel;

    public String globalInfo() {
        return "Trains a model based on the incoming dataset and outputs the built model alongside the dataset (in a model container).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_MODEL, BACKUP_MODEL, (Object)new CallableActorReference(DL4JModelConfigurator.class.getSimpleName()));
    }

    public void setModel(CallableActorReference value) {
        this.m_Model = value;
        this.reset();
    }

    public CallableActorReference getModel() {
        return this.m_Model;
    }

    public String modelTipText() {
        return "The model to train on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_MODEL, (Object)this.m_Model);
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_MODEL);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_MODEL, this.m_ActualModel);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_MODEL)) {
            this.m_ActualModel = (Model)state.get(BACKUP_MODEL);
            state.remove(BACKUP_MODEL);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_ActualModel = null;
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    public Class[] generates() {
        return new Class[]{DL4JModelContainer.class};
    }

    protected ModelConfigurator getModelConfiguratorInstance() throws Exception {
        MessageCollection errors = new MessageCollection();
        ModelConfigurator result = (ModelConfigurator)CallableActorHelper.getSetup(ModelConfigurator.class, (CallableActorReference)this.m_Model, (Actor)this, (MessageCollection)errors);
        if (result == null) {
            if (errors.isEmpty()) {
                throw new IllegalStateException("Failed to obtain model configurator from '" + this.m_Model + "'!");
            }
            throw new IllegalStateException("Failed to obtain model configurator from '" + this.m_Model + "':\n" + errors);
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            DataSet data = (DataSet)this.m_InputToken.getPayload();
            if (this.m_ActualModel == null) {
                ModelConfigurator conf = this.getModelConfiguratorInstance();
                this.m_ActualModel = conf.configureModel(data.numInputs(), data.numOutcomes());
                if (this.m_ActualModel == null) {
                    result = "Failed to obtain model?";
                }
            }
            if (result == null) {
                if (this.m_ActualModel instanceof MultiLayerNetwork) {
                    ((MultiLayerNetwork)this.m_ActualModel).init();
                    if (this.isLoggingEnabled()) {
                        ((MultiLayerNetwork)this.m_ActualModel).setListeners(new IterationListener[]{new ScoreIterationListener(){
                            private static final long serialVersionUID = -5322197573419602284L;

                            public void iterationDone(Model model, int iteration) {
                                if (iteration % 100 == 0) {
                                    this.invoke();
                                    DL4JTrainModel.this.getLogger().info("Score at iteration " + iteration + " is " + model.score());
                                }
                            }
                        }});
                    }
                    ((MultiLayerNetwork)this.m_ActualModel).fit((org.nd4j.linalg.dataset.api.DataSet)data);
                } else {
                    this.m_ActualModel.fit(data.getFeatureMatrix());
                }
                this.m_OutputToken = new Token((Object)new DL4JModelContainer(this.m_ActualModel, data));
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualModel = null;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.MODEL_GENERATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

