/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.DL4JEvaluationContainer;
import adams.flow.container.DL4JTrainTestSetContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractCallableDL4JModelEvaluator;
import adams.ml.dl4j.model.ModelConfigurator;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.api.DataSet;

public class DL4JTrainTestSetEvaluator
extends AbstractCallableDL4JModelEvaluator
implements ProvenanceSupporter {
    private static final long serialVersionUID = -1092101024095887007L;

    public String globalInfo() {
        return "Trains a model on an incoming training dataset (from a container) and then evaluates it on the test set (also from a container).\nThe model setup being used in the evaluation is obtained from the callable actor returning a model configurator.";
    }

    @Override
    public String modelTipText() {
        return "The callable model configurator actor to obtain the model from to train and evaluate on the test data.";
    }

    public Class[] accepts() {
        return new Class[]{DL4JTrainTestSetContainer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            ModelConfigurator conf = this.getModelConfiguratorInstance();
            if (conf == null) {
                throw new IllegalStateException("Classifier '" + this.getModel() + "' not found!");
            }
            DL4JTrainTestSetContainer cont = (DL4JTrainTestSetContainer)((Object)this.m_InputToken.getPayload());
            org.nd4j.linalg.dataset.DataSet train = (org.nd4j.linalg.dataset.DataSet)cont.getValue("Train");
            org.nd4j.linalg.dataset.DataSet test = (org.nd4j.linalg.dataset.DataSet)cont.getValue("Test");
            Model model = conf.configureModel(train.numInputs(), train.numOutcomes());
            Evaluation eval = null;
            if (model instanceof MultiLayerNetwork) {
                ((MultiLayerNetwork)model).fit((DataSet)train);
            } else {
                result = "Can only evaluate " + MultiLayerNetwork.class.getName() + "!";
            }
            if (result == null) {
                eval = new Evaluation(train.numOutcomes());
                eval.eval(test.getLabels(), ((MultiLayerNetwork)model).output(test.getFeatureMatrix(), Layer.TrainingMode.TEST));
            }
            if (eval != null) {
                this.m_OutputToken = this.m_AlwaysUseContainer ? new Token((Object)new DL4JEvaluationContainer(eval, conf)) : new Token((Object)eval.stats());
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to evaluate: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

