/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

public enum EvaluationStatistic implements EnumWithCustomDisplay<EvaluationStatistic>
{
    ACCURACY("Accuracy", false),
    CLASS_COUNT("Class count", true),
    F1("F1", false),
    F1_CLASS("F1", true),
    FALSE_ALARM_RATE("False alarm rate", false),
    FALSE_NEGATIVE_RATE("False negative rate", false),
    FALSE_NEGATIVE_RATE_CLASS("False negative rate", true),
    FALSE_POSITIVE_RATE("False positive rate", false),
    FALSE_POSITIVE_RATE_CLASS("False positive rate", true),
    PRECISION("Precision", false),
    PRECISION_CLASS("Precision", true),
    RECALL("Recall", false),
    RECALL_CLASS("Recall", true),
    ROW_COUNT("Row count", false);

    private String m_Display;
    private String m_Raw;
    private boolean m_PerClass;

    private EvaluationStatistic(String display) {
        this(display, false);
    }

    private EvaluationStatistic(String display, boolean perClass) {
        this.m_Display = display + (perClass ? " (class)" : "");
        this.m_Raw = super.toString();
        this.m_PerClass = perClass;
    }

    public boolean isPerClass() {
        return this.m_PerClass;
    }

    public String toDisplay() {
        return this.m_Display;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public EvaluationStatistic parse(String s) {
        return EvaluationStatistic.valueOf((AbstractOption)null, s);
    }

    public String toString() {
        return this.m_Display;
    }

    public static String toString(AbstractOption option, Object object) {
        return ((EvaluationStatistic)((Object)object)).toRaw();
    }

    public static EvaluationStatistic valueOf(AbstractOption option, String str) {
        EvaluationStatistic result = null;
        try {
            result = EvaluationStatistic.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (EvaluationStatistic f : EvaluationStatistic.values()) {
                if (!f.toDisplay().equals(str)) continue;
                result = f;
                break;
            }
        }
        return result;
    }
}

