/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.model;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.model.AbstractScriptedModelConfigurator;
import adams.ml.dl4j.model.ModelConfigurator;
import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ModelWithScriptedConfiguration
extends AbstractScriptedModelConfigurator
implements Model {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient ModelConfigurator m_ModelConfiguratorObject;
    protected Model m_Model;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta-model that uses any scripting handler for generating the model in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(ModelConfigurator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_ModelConfiguratorObject = (ModelConfigurator)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ModelConfiguratorObject = null;
    }

    @Override
    public Model configureModel(int numInput, int numOutput) {
        String msg;
        this.m_Model = null;
        if (this.m_ModelConfiguratorObject == null && (msg = this.check()) != null) {
            throw new IllegalStateException(msg);
        }
        if (this.m_ModelConfiguratorObject == null) {
            throw new IllegalStateException("No model generator available!");
        }
        this.m_Model = this.m_ModelConfiguratorObject.configureModel(numInput, numOutput);
        return this.m_Model;
    }

    protected synchronized Model getModel() {
        return this.m_Model;
    }

    public void update(INDArray gradient, String paramType) {
        this.getModel().update(gradient, paramType);
    }

    public double score() {
        return this.getModel().score();
    }

    public void computeGradientAndScore() {
        this.getModel().computeGradientAndScore();
    }

    public void accumulateScore(double accum) {
        this.getModel().accumulateScore(accum);
    }

    public INDArray params() {
        return this.getModel().params();
    }

    public int numParams() {
        return this.getModel().numParams();
    }

    public int numParams(boolean backwards) {
        return this.getModel().numParams(backwards);
    }

    public void setParams(INDArray params) {
        this.getModel().setParams(params);
    }

    public void setParamsViewArray(INDArray indArray) {
        this.getModel().setParamsViewArray(indArray);
    }

    public void setBackpropGradientsViewArray(INDArray indArray) {
        this.getModel().setBackpropGradientsViewArray(indArray);
    }

    public void applyLearningRateScoreDecay() {
        this.getModel().applyLearningRateScoreDecay();
    }

    public void fit() {
        this.getModel().fit();
    }

    public void fit(INDArray data) {
        this.getModel().fit(data);
    }

    public void iterate(INDArray input) {
        this.getModel().iterate(input);
    }

    public Gradient gradient() {
        return this.getModel().gradient();
    }

    public Pair<Gradient, Double> gradientAndScore() {
        return this.getModel().gradientAndScore();
    }

    public int batchSize() {
        return this.getModel().batchSize();
    }

    public NeuralNetConfiguration conf() {
        return this.getModel().conf();
    }

    public void setConf(NeuralNetConfiguration conf) {
        this.getModel().setConf(conf);
    }

    public INDArray input() {
        return this.getModel().input();
    }

    public void validateInput() {
        this.getModel().validateInput();
    }

    public ConvexOptimizer getOptimizer() {
        return this.getModel().getOptimizer();
    }

    public INDArray getParam(String param) {
        return this.getModel().getParam(param);
    }

    public void initParams() {
        this.getModel().initParams();
    }

    public Map<String, INDArray> paramTable() {
        return this.getModel().paramTable();
    }

    public void setParamTable(Map<String, INDArray> paramTable) {
        this.getModel().setParamTable(paramTable);
    }

    public void setParam(String key, INDArray val) {
        this.getModel().setParam(key, val);
    }

    public void clear() {
        this.getModel().clear();
    }
}

