/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.model;

import adams.core.Randomizable;
import adams.ml.dl4j.model.AbstractModelConfigurator;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.RBM;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class SimpleMultiLayerNetwork
extends AbstractModelConfigurator
implements Randomizable {
    private static final long serialVersionUID = -4915929902612899539L;
    protected int m_NumIterations;
    protected float m_LearningRate;
    protected long m_Seed;
    protected OptimizationAlgorithm m_OptimizationAlgorithm;
    protected boolean m_UseRegularization;
    protected double m_L1;
    protected double m_L2;
    protected boolean m_UseDropConnect;
    protected int m_HiddenNodes;
    protected String m_HiddenActivation;
    protected LossFunctions.LossFunction m_HiddenLossFunction;
    protected WeightInit m_HiddenWeightInit;
    protected Updater m_HiddenUpdater;
    protected double m_HiddenDropOut;
    protected String m_OutputActivation;
    protected LossFunctions.LossFunction m_OutputLossFunction;

    public String globalInfo() {
        return "A simple multilayer network, adapted from the iris flow tutorial:\nhttp://deeplearning4j.org/iris-flower-dataset-tutorial";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-iterations", "numIterations", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("learning-rate", "learningRate", (Object)Float.valueOf(1.0E-6f), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("optimization-algorithm", "optimizationAlgorithm", (Object)OptimizationAlgorithm.CONJUGATE_GRADIENT);
        this.m_OptionManager.add("use-regularization", "useRegularization", (Object)true);
        this.m_OptionManager.add("l1", "l1", (Object)0.1, (Number)0.0, null);
        this.m_OptionManager.add("l2", "l2", (Object)2.0E-4, (Number)0.0, null);
        this.m_OptionManager.add("use-drop-connect", "useDropConnect", (Object)true);
        this.m_OptionManager.add("hidden-nodes", "hiddenNodes", (Object)3, (Number)1, null);
        this.m_OptionManager.add("hidden-activation", "hiddenActivation", (Object)"relu");
        this.m_OptionManager.add("hidden-loss-function", "hiddenLossFunction", (Object)LossFunctions.LossFunction.RMSE_XENT);
        this.m_OptionManager.add("hidden-weight-init", "hiddenWeightInit", (Object)WeightInit.XAVIER);
        this.m_OptionManager.add("hidden-updater", "hiddenUpdater", (Object)Updater.ADAGRAD);
        this.m_OptionManager.add("hidden-drop-out", "hiddenDropOut", (Object)0.5);
        this.m_OptionManager.add("output-activation", "outputActivation", (Object)"softmax");
        this.m_OptionManager.add("output-loss-function", "outputLossFunction", (Object)LossFunctions.LossFunction.MCXENT);
    }

    public void setNumIterations(int value) {
        if (this.getOptionManager().isValid("numIterations", (Number)value)) {
            this.m_NumIterations = value;
            this.reset();
        }
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setLearningRate(float value) {
        if (this.getOptionManager().isValid("learningRate", (Number)Float.valueOf(value))) {
            this.m_LearningRate = value;
            this.reset();
        }
    }

    public float getLearningRate() {
        return this.m_LearningRate;
    }

    public String learningRateTipText() {
        return "The learning rate to use.";
    }

    public void setSeed(long value) {
        if (this.getOptionManager().isValid("seed", (Number)value)) {
            this.m_Seed = value;
            this.reset();
        }
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the weight initialization.";
    }

    public void setOptimizationAlgorithm(OptimizationAlgorithm value) {
        this.m_OptimizationAlgorithm = value;
        this.reset();
    }

    public OptimizationAlgorithm getOptimizationAlgorithm() {
        return this.m_OptimizationAlgorithm;
    }

    public String optimizationAlgorithmTipText() {
        return "The optimization algorithm.";
    }

    public void setUseRegularization(boolean value) {
        this.m_UseRegularization = value;
        this.reset();
    }

    public boolean getUseRegularization() {
        return this.m_UseRegularization;
    }

    public String useRegularizationTipText() {
        return "If enabled, regularization is used.";
    }

    public void setL1(double value) {
        if (this.getOptionManager().isValid("l1", (Number)value)) {
            this.m_L1 = value;
            this.reset();
        }
    }

    public double getL1() {
        return this.m_L1;
    }

    public String l1TipText() {
        return "The L1 value.";
    }

    public void setL2(double value) {
        if (this.getOptionManager().isValid("l2", (Number)value)) {
            this.m_L2 = value;
            this.reset();
        }
    }

    public double getL2() {
        return this.m_L2;
    }

    public String l2TipText() {
        return "The L2 value.";
    }

    public void setUseDropConnect(boolean value) {
        this.m_UseDropConnect = value;
        this.reset();
    }

    public boolean getUseDropConnect() {
        return this.m_UseDropConnect;
    }

    public String useDropConnectTipText() {
        return "If enabled, drop-connect is used.";
    }

    public void setHiddenNodes(int value) {
        this.m_HiddenNodes = value;
        this.reset();
    }

    public int getHiddenNodes() {
        return this.m_HiddenNodes;
    }

    public String hiddenNodesTipText() {
        return "The number of hidden nodes.";
    }

    public void setHiddenActivation(String value) {
        this.m_HiddenActivation = value;
        this.reset();
    }

    public String getHiddenActivation() {
        return this.m_HiddenActivation;
    }

    public String hiddenActivationTipText() {
        return "The activation to use for the hidden layer; eg relu (rectified linear), tanh, sigmoid, softmax, hardtanh, leakyrelu, maxout, softsign, softplus.";
    }

    public void setHiddenLossFunction(LossFunctions.LossFunction value) {
        this.m_HiddenLossFunction = value;
        this.reset();
    }

    public LossFunctions.LossFunction getHiddenLossFunction() {
        return this.m_HiddenLossFunction;
    }

    public String hiddenLossFunctionTipText() {
        return "The loss function to use for the hidden layer.";
    }

    public void setHiddenWeightInit(WeightInit value) {
        this.m_HiddenWeightInit = value;
        this.reset();
    }

    public WeightInit getHiddenWeightInit() {
        return this.m_HiddenWeightInit;
    }

    public String hiddenWeightInitTipText() {
        return "The weight init to use for the hidden layer.";
    }

    public void setHiddenUpdater(Updater value) {
        this.m_HiddenUpdater = value;
        this.reset();
    }

    public Updater getHiddenUpdater() {
        return this.m_HiddenUpdater;
    }

    public String hiddenUpdaterTipText() {
        return "The updater to use for the hidden layer.";
    }

    public void setHiddenDropOut(double value) {
        if (this.getOptionManager().isValid("hiddenDropOut", (Number)value)) {
            this.m_HiddenDropOut = value;
            this.reset();
        }
    }

    public double getHiddenDropOut() {
        return this.m_HiddenDropOut;
    }

    public String hiddenDropOutTipText() {
        return "The drop-out to use for the hidden layer.";
    }

    public void setOutputActivation(String value) {
        this.m_OutputActivation = value;
        this.reset();
    }

    public String getOutputActivation() {
        return this.m_OutputActivation;
    }

    public String outputActivationTipText() {
        return "The activation to use for the output layer; eg relu (rectified linear), tanh, sigmoid, softmax, hardtanh, leakyrelu, maxout, softsign, softplus.";
    }

    public void setOutputLossFunction(LossFunctions.LossFunction value) {
        this.m_OutputLossFunction = value;
        this.reset();
    }

    public LossFunctions.LossFunction getOutputLossFunction() {
        return this.m_OutputLossFunction;
    }

    public String outputLossFunctionTipText() {
        return "The loss function to use for the output layer.";
    }

    @Override
    protected Model doConfigureModel(int numInput, int numOutput) {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.m_Seed).iterations(this.m_NumIterations).learningRate((double)this.m_LearningRate).optimizationAlgo(this.m_OptimizationAlgorithm).l1(this.m_L1).regularization(this.m_UseRegularization).l2(this.m_L2).useDropConnect(this.m_UseDropConnect).list().layer(0, (Layer)((RBM.Builder)((RBM.Builder)((RBM.Builder)((RBM.Builder)((RBM.Builder)((RBM.Builder)((RBM.Builder)new RBM.Builder(RBM.HiddenUnit.RECTIFIED, RBM.VisibleUnit.GAUSSIAN).nIn(numInput)).nOut(this.m_HiddenNodes)).weightInit(this.m_HiddenWeightInit)).k(1).activation(this.m_HiddenActivation)).lossFunction(this.m_HiddenLossFunction)).updater(this.m_HiddenUpdater)).dropOut(this.m_HiddenDropOut)).build()).layer(1, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(this.m_OutputLossFunction).nIn(this.m_HiddenNodes)).nOut(numOutput)).activation(this.m_OutputActivation)).build()).build();
        return new MultiLayerNetwork(conf);
    }
}

