/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.ml.dl4j.model.ModelConfigurator;
import org.deeplearning4j.nn.api.Model;

public class DL4JConfiguratorToModel
extends AbstractConversion {
    private static final long serialVersionUID = -4013081305335693154L;
    protected int m_NumInput;
    protected int m_NumOutput;

    public String globalInfo() {
        return "Generates a concrete model object from the incoming configurator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-input", "numInput", (Object)1, (Number)1, null);
        this.m_OptionManager.add("num-output", "numOutput", (Object)1, (Number)1, null);
    }

    public void setNumInput(int value) {
        if (this.getOptionManager().isValid("numInput", (Number)value)) {
            this.m_NumInput = value;
            this.reset();
        }
    }

    public int getNumInput() {
        return this.m_NumInput;
    }

    public String numInputTipText() {
        return "The number of input nodes to use.";
    }

    public void setNumOutput(int value) {
        if (this.getOptionManager().isValid("numOutput", (Number)value)) {
            this.m_NumOutput = value;
            this.reset();
        }
    }

    public int getNumOutput() {
        return this.m_NumOutput;
    }

    public String numOutputTipText() {
        return "The number of output nodes to use.";
    }

    public Class accepts() {
        return ModelConfigurator.class;
    }

    public Class generates() {
        return Model.class;
    }

    protected Object doConvert() throws Exception {
        ModelConfigurator conf = (ModelConfigurator)this.m_Input;
        return conf.configureModel(this.m_NumInput, this.m_NumOutput);
    }
}

