/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JDataSetToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -8817702395174849629L;

    public String globalInfo() {
        return "Converts a DL4J DataSet into a spreadsheet.";
    }

    public Class accepts() {
        return DataSet.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        DataSet input = (DataSet)this.m_Input;
        INDArray features = input.getFeatures();
        INDArray labels = input.getLabels();
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < features.columns(); ++i) {
            row.addCell("" + i).setContentAsString("att-" + (i + 1));
        }
        int offset = row.getCellCount();
        for (i = 0; i < labels.columns(); ++i) {
            row.addCell("" + (offset + i)).setContentAsString("class-" + (i + 1));
        }
        for (int j = 0; j < features.rows(); ++j) {
            row = result.addRow();
            for (i = 0; i < features.columns(); ++i) {
                row.addCell("" + i).setContent(Double.valueOf(features.getDouble(j, i)));
            }
            for (i = 0; i < labels.columns(); ++i) {
                row.addCell("" + (offset + i)).setContent(Double.valueOf(labels.getDouble(j, i)));
            }
        }
        return result;
    }
}

