/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import org.deeplearning4j.nn.api.Model;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DL4JModelParamsToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -8817702395174849629L;

    public String globalInfo() {
        return "Extracts the parameter matrix of a DL4J model and turns it into a spreadsheet.";
    }

    public Class accepts() {
        return Model.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        Model model = (Model)this.m_Input;
        INDArray params = model.params();
        int rows = params.rows();
        int cols = params.columns();
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        for (i = 0; i < cols; ++i) {
            row.addCell("" + i).setContentAsString("Col-" + (i + 1));
        }
        for (int n = 0; n < rows; ++n) {
            INDArray prow = params.getRow(n);
            row = result.addRow();
            for (i = 0; i < cols; ++i) {
                row.addCell(i).setContent(Double.valueOf(prow.getDouble(i)));
            }
        }
        return result;
    }
}

