/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.conversion.StringToJson;
import net.minidev.json.JSONAware;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;

public class DL4JModelToJson
extends AbstractConversion {
    private static final long serialVersionUID = -8817702395174849629L;

    public String globalInfo() {
        return "Converts a DL4J model into its JSON representation.";
    }

    public Class accepts() {
        return Model.class;
    }

    public Class generates() {
        return JSONAware.class;
    }

    protected Object doConvert() throws Exception {
        String jsonStr = this.m_Input instanceof MultiLayerNetwork ? ((MultiLayerNetwork)this.m_Input).getLayerWiseConfigurations().toJson() : (this.m_Input instanceof ComputationGraph ? ((ComputationGraph)this.m_Input).getConfiguration().toJson() : ((Model)this.m_Input).conf().toJson());
        StringToJson conv = new StringToJson();
        conv.setInput((Object)jsonStr);
        String msg = conv.convert();
        if (msg != null) {
            throw new Exception("Failed to parse JSON string from model!\n" + msg);
        }
        Object result = conv.getOutput();
        conv.cleanUp();
        return result;
    }
}

