/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.ml.dl4j.model.ModelType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;

public class DL4JYamlToModel
extends AbstractConversion {
    private static final long serialVersionUID = -4013081305335693154L;
    protected ModelType m_Type;

    public String globalInfo() {
        return "Converts a YAML string into a deeplearning4j model.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)ModelType.MULTI_LAYER_NETWORK);
    }

    public void setType(ModelType value) {
        this.m_Type = value;
        this.reset();
    }

    public ModelType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of model to instantiate.";
    }

    public Class accepts() {
        return String.class;
    }

    public Class generates() {
        switch (this.m_Type) {
            case MULTI_LAYER_NETWORK: {
                return MultiLayerNetwork.class;
            }
            case COMPUTATION_GRAPH: {
                return ComputationGraph.class;
            }
        }
        throw new IllegalStateException("Unhanded model type: " + (Object)((Object)this.m_Type));
    }

    protected Object doConvert() throws Exception {
        String yaml = (String)this.m_Input;
        switch (this.m_Type) {
            case MULTI_LAYER_NETWORK: {
                return new MultiLayerNetwork(MultiLayerConfiguration.fromYaml((String)yaml));
            }
            case COMPUTATION_GRAPH: {
                return new ComputationGraph(ComputationGraphConfiguration.fromYaml((String)yaml));
            }
        }
        throw new IllegalStateException("Unhanded model type: " + (Object)((Object)this.m_Type));
    }
}

