/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.eval.RegressionEvaluation;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JModelContainer
extends AbstractContainer {
    private static final long serialVersionUID = 5581530171877321061L;
    public static final String VALUE_MODEL = "Model";
    public static final String VALUE_BEST_MODEL = "Best Model";
    public static final String VALUE_BEST_STATISTICS = "Best Statistics";
    public static final String VALUE_DATASET = "Dataset";
    public static final String VALUE_EPOCH = "Epoch";
    public static final String VALUE_EVALUATION = "Evaluation";
    public static final String VALUE_TRAIN_STOP_MESSAGES = "Train Stop Messages";

    public DL4JModelContainer() {
        this(null);
    }

    public DL4JModelContainer(Object model) {
        this(model, null);
    }

    public DL4JModelContainer(Object model, DataSet data) {
        this(model, data, null);
    }

    public DL4JModelContainer(Object model, DataSet data, Integer epoch) {
        this(model, data, epoch, null);
    }

    public DL4JModelContainer(Object model, DataSet data, Integer epoch, Object evaluation) {
        this(model, data, epoch, evaluation, null, null);
    }

    public DL4JModelContainer(Object model, DataSet data, Integer epoch, Object evaluation, Object bestModel, Map<String, Double> bestStats) {
        this.store(VALUE_MODEL, model);
        this.store(VALUE_BEST_MODEL, bestModel);
        this.store(VALUE_BEST_STATISTICS, bestStats);
        this.store(VALUE_DATASET, data);
        this.store(VALUE_EPOCH, epoch);
        this.store(VALUE_EVALUATION, evaluation);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_MODEL, "model object", Object.class);
        this.addHelp(VALUE_BEST_MODEL, "best model object", Object.class);
        this.addHelp(VALUE_BEST_STATISTICS, "best model statistics", Map.class);
        this.addHelp(VALUE_DATASET, "full dataset", DataSet.class);
        this.addHelp(VALUE_EPOCH, "epoch", Integer.class);
        this.addHelp(VALUE_EVALUATION, "evaluation", new Class[]{Evaluation.class, RegressionEvaluation.class});
        this.addHelp(VALUE_TRAIN_STOP_MESSAGES, "train stop criteria that triggered", String[].class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_MODEL);
        result.add(VALUE_BEST_MODEL);
        result.add(VALUE_BEST_STATISTICS);
        result.add(VALUE_DATASET);
        result.add(VALUE_EPOCH);
        result.add(VALUE_EVALUATION);
        result.add(VALUE_TRAIN_STOP_MESSAGES);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_MODEL);
    }
}

