/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.SerializationHelper;
import adams.flow.container.DL4JModelContainer;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;

public abstract class AbstractDL4JModelWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -259222073894194923L;

    public String outputFileTipText() {
        return "The filename to save the model in.";
    }

    public Class[] accepts() {
        ArrayList<Class> result = new ArrayList<Class>();
        result.add(DL4JModelContainer.class);
        result.addAll(Arrays.asList(this.getAdditionalAcceptedClasses()));
        return result.toArray(new Class[result.size()]);
    }

    protected Class[] getAdditionalAcceptedClasses() {
        return new Class[0];
    }

    protected String doExecute() {
        String result = null;
        try {
            Model model = null;
            Object obj = null;
            if (this.m_InputToken.getPayload() instanceof DL4JModelContainer) {
                DL4JModelContainer cont = (DL4JModelContainer)((Object)this.m_InputToken.getPayload());
                model = (Model)cont.getValue("Model");
            } else if (this.m_InputToken.getPayload() instanceof Model) {
                model = (Model)this.m_InputToken.getPayload();
            } else {
                obj = this.m_InputToken.getPayload();
            }
            if (model != null) {
                if (model instanceof MultiLayerNetwork && !((MultiLayerNetwork)model).isInitCalled()) {
                    ((MultiLayerNetwork)model).init();
                }
                ModelSerializer.writeModel((Model)model, (File)this.m_OutputFile.getAbsoluteFile(), (boolean)true);
            } else if (obj != null) {
                SerializationHelper.write((String)this.m_OutputFile.getAbsolutePath(), (Object)obj);
            } else {
                result = "Don't know how to save object of type: " + this.m_InputToken.getPayload().getClass();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to serialize model data to '" + this.m_OutputFile + "':", e);
        }
        return result;
    }
}

