/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JTrainTestSetContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Random;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.KFoldIterator;
import org.nd4j.linalg.factory.Nd4j;

public class DL4JCrossValidationSplit
extends AbstractTransformer
implements Randomizable,
ProvenanceSupporter {
    private static final long serialVersionUID = 4026105903223741240L;
    public static final String BACKUP_ITERATOR = "Iterator";
    protected long m_Seed;
    protected int m_Folds;
    protected transient KFoldIterator m_Generator;

    public String globalInfo() {
        return "Generates train/test pairs like during a cross-validation run.\nIt is essential that a class attribute is set. The training set can be accessed in the container with 'Train' and the test set with 'Test'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)2, null);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)"seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"folds", (Object)this.m_Folds, (String)", folds: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    public Class[] generates() {
        return new Class[]{DL4JTrainTestSetContainer.class};
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization.";
    }

    public void setFolds(int value) {
        if (this.getOptionManager().isValid("folds", (Number)value)) {
            this.m_Folds = value;
            this.reset();
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The folds to use.";
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_ITERATOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Generator != null) {
            result.put(BACKUP_ITERATOR, this.m_Generator);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_ITERATOR)) {
            this.m_Generator = (KFoldIterator)state.get(BACKUP_ITERATOR);
            state.remove(BACKUP_ITERATOR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Generator = null;
    }

    protected String doExecute() {
        String result = null;
        DataSet data = (DataSet)this.m_InputToken.getPayload();
        Nd4j.shuffle((INDArray)data.getFeatureMatrix(), (Random)new Random(this.m_Seed), (int[])new int[]{1});
        if (data.getLabels() != null) {
            Nd4j.shuffle((INDArray)data.getLabels(), (Random)new Random(this.m_Seed), (int[])new int[]{1});
        }
        try {
            this.m_Generator = new KFoldIterator(this.m_Folds, data);
        }
        catch (Exception e) {
            result = this.handleException("Failed to initialize fold iterator!", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Generator != null && this.m_Generator.hasNext();
    }

    public Token output() {
        DataSet train = this.m_Generator.next();
        DataSet test = this.m_Generator.testFold();
        Token result = new Token((Object)new DL4JTrainTestSetContainer(train, test));
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        this.m_Generator = null;
        super.wrapUp();
    }
}

