/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.DataSetHelper;
import java.util.Arrays;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JDatasetAppend
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -268487303904639474L;

    public String globalInfo() {
        return "Creates one large dataset by appending all, one after the other.";
    }

    public Class[] accepts() {
        return new Class[]{DataSet[].class};
    }

    public Class[] generates() {
        return new Class[]{DataSet.class};
    }

    protected String doExecute() {
        String result = null;
        if (!(this.m_InputToken.getPayload() instanceof DataSet[])) {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        DataSet[] data = (DataSet[])this.m_InputToken.getPayload();
        for (int i = 0; i < data.length - 1; ++i) {
            for (int n = i + 1; n < data.length; ++n) {
                String msg = DataSetHelper.equalStructureMsg(data[i], data[n]);
                if (msg == null) continue;
                result = "Dataset #" + (i + 1) + " and #" + (n + 1) + " are not compatible:\n" + msg;
                break;
            }
            if (result != null) break;
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)DataSet.merge(Arrays.asList(data)));
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

