/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JDatasetInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs information about a DataSet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_EXAMPLES);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public String outputArrayTipText() {
        return "Whether to output the values one-by-one or as array (counts or distributions are always output as array).";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate; NB some of the types are only available for numeric or nominal attributes.";
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case NUM_EXAMPLES: 
            case NUM_INPUTS: 
            case NUM_OUTCOMES: {
                return Integer.class;
            }
            case COLUMN_NAMES: 
            case LABELS: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        DataSet data = (DataSet)this.m_InputToken.getPayload();
        this.m_Queue.clear();
        switch (this.m_Type) {
            case NUM_EXAMPLES: {
                this.m_Queue.add(data.numExamples());
                break;
            }
            case NUM_INPUTS: {
                this.m_Queue.add(data.numInputs());
                break;
            }
            case NUM_OUTCOMES: {
                this.m_Queue.add(data.numOutcomes());
                break;
            }
            case COLUMN_NAMES: {
                this.m_Queue.addAll(data.getColumnNames());
                break;
            }
            case LABELS: {
                this.m_Queue.addAll(data.getLabelNamesList());
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public static enum InfoType {
        NUM_INPUTS,
        NUM_OUTCOMES,
        NUM_EXAMPLES,
        COLUMN_NAMES,
        LABELS;

    }
}

