/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.flow.container.DL4JTrainTestSetContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.DataSetHelper;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JRandomSplit
extends AbstractTransformer
implements Randomizable,
ProvenanceSupporter {
    private static final long serialVersionUID = -6447945986570354931L;
    protected boolean m_PreserveOrder;
    protected long m_Seed;
    protected double m_Percentage;

    public String globalInfo() {
        return "Splits a dataset into a training and test set according to a specified split percentage.\nThe training set can be accessed in the container with 'Train' and the test set with 'Test'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preserve-order", "preserveOrder", (Object)false);
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("percentage", "percentage", (Object)0.66, (Number)1.0E-4, (Number)0.9999);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"percentage", (Object)this.m_Percentage);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed, (String)", seed: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preserveOrder", (boolean)this.m_PreserveOrder, (String)"order preserved", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    public Class[] generates() {
        return new Class[]{DL4JTrainTestSetContainer.class};
    }

    public void setPreserveOrder(boolean value) {
        this.m_PreserveOrder = value;
        this.reset();
    }

    public boolean getPreserveOrder() {
        return this.m_PreserveOrder;
    }

    public String preserveOrderTipText() {
        return "If set to true, then the order is preserved by suppressing randomization.";
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization.";
    }

    public void setPercentage(double value) {
        if (this.getOptionManager().isValid("percentage", (Number)value)) {
            this.m_Percentage = value;
            this.reset();
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage for the split (between 0 and 1).";
    }

    protected String doExecute() {
        DataSet data = (DataSet)this.m_InputToken.getPayload();
        DataSet[] split = DataSetHelper.split(data, this.m_Percentage, this.m_PreserveOrder ? null : Long.valueOf(this.m_Seed));
        DL4JTrainTestSetContainer cont = new DL4JTrainTestSetContainer(split[0], split[1], this.m_Seed);
        this.m_OutputToken = new Token((Object)cont);
        this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        return null;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

