/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import adams.ml.dl4j.DataSetHelper;
import org.nd4j.linalg.dataset.DataSet;

public class DL4JRandomizeDataset
extends AbstractTransformer
implements ProvenanceSupporter,
Randomizable,
InPlaceProcessing {
    private static final long serialVersionUID = -268487303904639474L;
    protected long m_Seed;
    protected boolean m_NoCopy;

    public String globalInfo() {
        return "Randomizes the incoming dataset.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the randomization.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the dataset is created before processing it.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"seed", (Object)this.m_Seed);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no-copy", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{DataSet.class};
    }

    public Class[] generates() {
        return new Class[]{DataSet.class};
    }

    protected String doExecute() {
        DataSet data = (DataSet)this.m_InputToken.getPayload();
        data = DataSetHelper.randomize(data, this.m_Seed, !this.m_NoCopy);
        this.m_OutputToken = new Token((Object)data);
        return null;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

