/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.data.conversion.Conversion;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.Fonts;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;

public abstract class AbstractDL4JSerializedModelHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1277627290853745369L;

    protected String checkFile(File file) {
        String result = super.checkFile(file);
        if (result == null) {
            try {
                ModelSerializer.restoreMultiLayerNetwork((File)file.getAbsoluteFile());
            }
            catch (Exception e1) {
                try {
                    ModelSerializer.restoreComputationGraph((File)file.getAbsoluteFile());
                    result = null;
                }
                catch (Exception e2) {
                    return "Neither a multi-layer network nor a computation graph!";
                }
            }
        }
        return result;
    }

    protected abstract Conversion getModelConversion();

    protected PreviewPanel createPreview(File file) {
        MultiLayerNetwork obj;
        try {
            obj = ModelSerializer.restoreMultiLayerNetwork((File)file.getAbsoluteFile());
        }
        catch (Exception e1) {
            try {
                obj = ModelSerializer.restoreComputationGraph((File)file.getAbsoluteFile());
            }
            catch (Exception e2) {
                return null;
            }
        }
        Conversion conv = this.getModelConversion();
        conv.setInput((Object)obj);
        String msg = conv.convert();
        if (msg != null) {
            return null;
        }
        BaseTextArea textObject = new BaseTextArea();
        textObject.setEditable(false);
        textObject.setFont(Fonts.getMonospacedFont());
        textObject.setText("" + conv.getOutput());
        PreviewPanel result = new PreviewPanel((JComponent)new BaseScrollPane((Component)textObject), (JComponent)textObject);
        return result;
    }
}

