/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j;

import adams.ml.dl4j.EvaluationStatistic;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.eval.RegressionEvaluation;

public class EvaluationHelper {
    public static double getValue(Evaluation eval, EvaluationStatistic statistic, int classIndex) throws Exception {
        switch (statistic) {
            case ACCURACY: {
                return eval.accuracy();
            }
            case CLASS_COUNT: {
                return eval.classCount(Integer.valueOf(classIndex));
            }
            case F1: {
                return eval.f1();
            }
            case F1_CLASS: {
                return eval.f1(classIndex);
            }
            case FALSE_ALARM_RATE: {
                return eval.falseAlarmRate();
            }
            case FALSE_NEGATIVE_RATE: {
                return eval.falseNegativeRate();
            }
            case FALSE_NEGATIVE_RATE_CLASS: {
                return eval.falseNegativeRate(Integer.valueOf(classIndex));
            }
            case FALSE_POSITIVE_RATE: {
                return eval.falsePositiveRate();
            }
            case FALSE_POSITIVE_RATE_CLASS: {
                return eval.falsePositiveRate(classIndex);
            }
            case PRECISION: {
                return eval.precision();
            }
            case PRECISION_CLASS: {
                return eval.precision(Integer.valueOf(classIndex));
            }
            case RECALL: {
                return eval.recall();
            }
            case RECALL_CLASS: {
                return eval.recall(classIndex);
            }
            case ROW_COUNT: {
                return eval.getNumRowCounter();
            }
            case AVG_F1_NUM_CLASSES_EXCLUDED: {
                return eval.averageF1NumClassesExcluded();
            }
            case AVG_F_BETA_NUM_CLASSES_EXCLUDED: {
                return eval.averageFBetaNumClassesExcluded();
            }
            case AVG_PRECISION_NUM_CLASSES_EXCLUDED: {
                return eval.averagePrecisionNumClassesExcluded();
            }
            case AVG_RECALL_NUM_CLASSES_EXCLUDED: {
                return eval.averageRecallNumClassesExcluded();
            }
        }
        if (statistic.isRegression() && !statistic.isClassification()) {
            throw new IllegalArgumentException("Regression statistic cannot be used on classification evaluation: " + (Object)((Object)statistic));
        }
        throw new IllegalArgumentException("Unhandled statistic field: " + (Object)((Object)statistic));
    }

    public static double getValue(RegressionEvaluation eval, EvaluationStatistic statistic, int column) throws Exception {
        switch (statistic) {
            case CORRELATION_R_SQUARED: {
                return eval.correlationR2(column);
            }
            case MEAN_ABSOLUTE_ERROR: {
                return eval.meanAbsoluteError(column);
            }
            case MEAN_SQUARED_ERROR: {
                return eval.meanSquaredError(column);
            }
            case RELATIVE_SQUARED_ERROR: {
                return eval.relativeSquaredError(column);
            }
            case ROOT_MEAN_SQUARED_ERROR: {
                return eval.rootMeanSquaredError(column);
            }
            case AVG_CORRELATION_R_SQUARED: {
                return eval.averagecorrelationR2();
            }
            case AVG_MEAN_ABSOLUTE_ERROR: {
                return eval.averageMeanAbsoluteError();
            }
            case AVG_MEAN_SQUARED_ERROR: {
                return eval.averageMeanSquaredError();
            }
            case AVG_RELATIVE_SQUARED_ERROR: {
                return eval.averagerelativeSquaredError();
            }
            case AVG_ROOT_MEAN_SQUARED_ERROR: {
                return eval.averagerootMeanSquaredError();
            }
        }
        if (!statistic.isRegression() && statistic.isClassification()) {
            throw new IllegalArgumentException("Classification statistic cannot be used on regression evaluation: " + (Object)((Object)statistic));
        }
        throw new IllegalArgumentException("Unhandled statistic field: " + (Object)((Object)statistic));
    }
}

