/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;

public enum EvaluationStatistic implements EnumWithCustomDisplay<EvaluationStatistic>
{
    ACCURACY("Accuracy", false, true, true),
    CLASS_COUNT("Class count", true, true, true),
    F1("F1", false, true, true),
    F1_CLASS("F1", true, true, true),
    FALSE_ALARM_RATE("False alarm rate", false, true, false),
    FALSE_NEGATIVE_RATE("False negative rate", false, true, false),
    FALSE_NEGATIVE_RATE_CLASS("False negative rate", true, true, false),
    FALSE_POSITIVE_RATE("False positive rate", false, true, false),
    FALSE_POSITIVE_RATE_CLASS("False positive rate", true, true, false),
    PRECISION("Precision", false, true, true),
    PRECISION_CLASS("Precision", true, true, true),
    RECALL("Recall", false, true, true),
    RECALL_CLASS("Recall", true, true, true),
    ROW_COUNT("Row count", false, true, true),
    AVG_F1_NUM_CLASSES_EXCLUDED("Average F1 num classes excluded", false, true, false),
    AVG_F_BETA_NUM_CLASSES_EXCLUDED("Average F Beta num classes excluded", false, true, false),
    AVG_PRECISION_NUM_CLASSES_EXCLUDED("Average Precision num classes excluded", false, true, false),
    AVG_RECALL_NUM_CLASSES_EXCLUDED("Average Recall num classes excluded", false, true, false),
    CORRELATION_R_SQUARED("Correlation R^2", false, false, true),
    MEAN_ABSOLUTE_ERROR("Mean absolute error", false, false, false),
    MEAN_SQUARED_ERROR("Mean squared error", false, false, false),
    RELATIVE_SQUARED_ERROR("Relative squared error", false, false, false),
    ROOT_MEAN_SQUARED_ERROR("Root mean squared error", false, false, false),
    AVG_CORRELATION_R_SQUARED("Average Correlation R^2", false, false, true),
    AVG_MEAN_ABSOLUTE_ERROR("Average Mean absolute error", false, false, false),
    AVG_MEAN_SQUARED_ERROR("Average Mean squared error", false, false, false),
    AVG_RELATIVE_SQUARED_ERROR("Average Relative squared error", false, false, false),
    AVG_ROOT_MEAN_SQUARED_ERROR("Average Root mean squared error", false, false, false);

    private String m_Display;
    private String m_Raw;
    private boolean m_PerClass;
    private Boolean m_Type;
    protected boolean m_HigherIsBetter;

    private EvaluationStatistic(String display, boolean perClass, Boolean type, boolean higherIsBetter) {
        this.m_Display = display + (perClass ? " (class)" : "");
        this.m_Raw = super.toString();
        this.m_PerClass = perClass;
        this.m_Type = type;
        this.m_HigherIsBetter = higherIsBetter;
    }

    public boolean isPerClass() {
        return this.m_PerClass;
    }

    public boolean isClassification() {
        return this.m_Type == null || this.m_Type != false;
    }

    public boolean isRegression() {
        return this.m_Type == null || this.m_Type == false;
    }

    public boolean isHigherIsBetter() {
        return this.m_HigherIsBetter;
    }

    public String toDisplay() {
        return this.m_Display;
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public EvaluationStatistic parse(String s) {
        return EvaluationStatistic.valueOf((AbstractOption)null, s);
    }

    public String toString() {
        return this.m_Display;
    }

    public int compare(double stat1, double stat2) {
        if (this.m_HigherIsBetter) {
            return Double.compare(stat1, stat2);
        }
        return -Double.compare(stat1, stat2);
    }

    public static String toString(AbstractOption option, Object object) {
        return ((EvaluationStatistic)((Object)object)).toRaw();
    }

    public static EvaluationStatistic valueOf(AbstractOption option, String str) {
        EvaluationStatistic result = null;
        try {
            result = EvaluationStatistic.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (EvaluationStatistic f : EvaluationStatistic.values()) {
                if (!f.toDisplay().equals(str)) continue;
                result = f;
                break;
            }
        }
        return result;
    }
}

