/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetiterator;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.datasetiterator.AbstractScriptedDataSetIteratorConfigurator;
import adams.ml.dl4j.datasetiterator.DataSetIteratorConfigurator;
import java.util.List;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class DataSetIteratorWithScriptedConfiguration
extends AbstractScriptedDataSetIteratorConfigurator
implements DataSetIterator {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient DataSetIteratorConfigurator m_DataSetIteratorConfiguratorObject;
    protected DataSetIterator m_DataSetIterator;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta-iterator that uses any scripting handler for generating the iterator in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(DataSetIteratorConfigurator.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_DataSetIteratorConfiguratorObject = (DataSetIteratorConfigurator)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_DataSetIteratorConfiguratorObject = null;
    }

    @Override
    public DataSetIterator configureDataSetIterator() {
        String msg;
        if (this.m_DataSetIteratorConfiguratorObject == null && (msg = this.check()) != null) {
            throw new IllegalStateException(msg);
        }
        if (this.m_DataSetIteratorConfiguratorObject != null) {
            return this.m_DataSetIteratorConfiguratorObject.configureDataSetIterator();
        }
        throw new IllegalStateException("No dataset iterator generator available!");
    }

    protected synchronized DataSetIterator getDataSetIterator() {
        if (this.m_DataSetIterator == null) {
            this.m_DataSetIterator = this.configureDataSetIterator();
        }
        return this.m_DataSetIterator;
    }

    public DataSet next(int i) {
        return this.getDataSetIterator().next(i);
    }

    public int totalExamples() {
        return this.getDataSetIterator().totalExamples();
    }

    public int inputColumns() {
        return this.getDataSetIterator().inputColumns();
    }

    public int totalOutcomes() {
        return this.getDataSetIterator().totalOutcomes();
    }

    public boolean resetSupported() {
        return this.getDataSetIterator().resetSupported();
    }

    public boolean asyncSupported() {
        return this.getDataSetIterator().asyncSupported();
    }

    public int batch() {
        return this.getDataSetIterator().batch();
    }

    public int cursor() {
        return this.getDataSetIterator().cursor();
    }

    public int numExamples() {
        return this.getDataSetIterator().numExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.getDataSetIterator().setPreProcessor(preProcessor);
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.getDataSetIterator().getPreProcessor();
    }

    public List<String> getLabels() {
        return this.getDataSetIterator().getLabels();
    }

    public boolean hasNext() {
        return this.getDataSetIterator().hasNext();
    }

    public DataSet next() {
        return (DataSet)this.getDataSetIterator().next();
    }
}

