/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetiterator;

import adams.ml.dl4j.datasetiterator.AbstractDataSetIteratorConfigurator;
import adams.ml.dl4j.recordreader.ImageRecordReaderConfigurator;
import adams.ml.dl4j.recordreader.RecordReaderConfigurator;
import org.datavec.api.io.WritableConverter;
import org.datavec.api.io.converters.SelfWritableConverter;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class RecordReaderDataSetIteratorConfigurator
extends AbstractDataSetIteratorConfigurator {
    private static final long serialVersionUID = 7600213724265033440L;
    protected RecordReaderConfigurator m_RecordReader;
    protected int m_BatchSize;
    protected int m_LabelIndex;
    protected int m_NumPossibleLabels;
    protected boolean m_Regression;

    public String globalInfo() {
        return "Configures a " + RecordReaderDataSetIterator.class.getName() + " instance, using the specified base record reader configurator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("record-reader", "recordReader", (Object)new ImageRecordReaderConfigurator());
        this.m_OptionManager.add("batch-size", "batchSize", (Object)10, (Number)1, null);
        this.m_OptionManager.add("label-index", "labelIndex", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("num-possible-labels", "numPossibleLabels", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("regression", "regression", (Object)false);
    }

    public void setRecordReader(RecordReaderConfigurator value) {
        this.m_RecordReader = value;
        this.reset();
    }

    public RecordReaderConfigurator getRecordReader() {
        return this.m_RecordReader;
    }

    public String recordReaderTipText() {
        return "The record reader configurator to use.";
    }

    public void setBatchSize(int value) {
        if (this.getOptionManager().isValid("batchSize", (Number)value)) {
            this.m_BatchSize = value;
            this.reset();
        }
    }

    public int getBatchSize() {
        return this.m_BatchSize;
    }

    public String batchSizeTipText() {
        return "The batch size to use.";
    }

    public void setLabelIndex(int value) {
        if (this.getOptionManager().isValid("labelIndex", (Number)value)) {
            this.m_LabelIndex = value;
            this.reset();
        }
    }

    public int getLabelIndex() {
        return this.m_LabelIndex;
    }

    public String labelIndexTipText() {
        return "The index of the attribute with the labels (0-based); use -1 for none (numPossibleLabels must be -1 then as well!).";
    }

    public void setNumPossibleLabels(int value) {
        if (this.getOptionManager().isValid("numPossibleLabels", (Number)value)) {
            this.m_NumPossibleLabels = value;
            this.reset();
        }
    }

    public int getNumPossibleLabels() {
        return this.m_NumPossibleLabels;
    }

    public String numPossibleLabelsTipText() {
        return "The number of possible labels; use -1 for none.";
    }

    public void setRegression(boolean value) {
        this.m_Regression = value;
        this.reset();
    }

    public boolean getRegression() {
        return this.m_Regression;
    }

    public String regressionTipText() {
        return "Whether regression or classification.";
    }

    @Override
    protected DataSetIterator doConfigureDataSetIterator() {
        return new RecordReaderDataSetIterator(this.m_RecordReader.configureRecordReader(), (WritableConverter)new SelfWritableConverter(), this.m_BatchSize, this.m_LabelIndex, this.m_NumPossibleLabels, this.m_Regression);
    }
}

