/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetiterator;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ShufflingDataSetIterator
implements DataSetIterator,
Serializable {
    private static final long serialVersionUID = 5571114918884888578L;
    protected DataSet m_data = null;
    protected int m_batchSize = 1;
    protected int m_cursor = 0;
    protected Random m_random = null;

    public ShufflingDataSetIterator(DataSet data, int batchSize, int seed) {
        this.m_data = data;
        this.m_batchSize = batchSize;
        this.m_random = new Random(seed);
    }

    public boolean hasNext() {
        return this.m_cursor + this.m_batchSize <= this.m_data.numExamples();
    }

    public DataSet next() {
        if (this.m_cursor == 0 && this.m_batchSize == 1 && this.m_data.numExamples() == 1) {
            return this.m_data;
        }
        DataSet thisBatch = (DataSet)this.m_data.getRange(this.m_cursor, this.m_cursor + this.m_batchSize);
        this.m_cursor += this.m_batchSize;
        return thisBatch;
    }

    public DataSet next(int num) {
        if (this.m_cursor == 0 && num == 1 && this.m_data.numExamples() == 1) {
            return this.m_data;
        }
        DataSet thisBatch = (DataSet)this.m_data.getRange(this.m_cursor, this.m_cursor + num);
        this.m_cursor += num;
        return thisBatch;
    }

    public int totalExamples() {
        return this.m_data.numExamples();
    }

    public int inputColumns() {
        return this.m_data.get(0).getFeatureMatrix().columns();
    }

    public int totalOutcomes() {
        return this.m_data.get(0).getLabels().columns();
    }

    public void reset() {
        this.m_cursor = 0;
        this.m_data.shuffle(this.m_random.nextLong());
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public int batch() {
        return this.m_batchSize;
    }

    public int cursor() {
        return this.m_cursor;
    }

    public int numExamples() {
        return this.m_data.numExamples();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        throw new UnsupportedOperationException();
    }

    public DataSetPreProcessor getPreProcessor() {
        throw new UnsupportedOperationException();
    }

    public List<String> getLabels() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

