/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.datasetpreprocessor;

import adams.ml.dl4j.datasetpreprocessor.AbstractDataSetPreProcessorConfigurator;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.ImagePreProcessingScaler;

public class ImageScaler
extends AbstractDataSetPreProcessorConfigurator {
    private static final long serialVersionUID = 6871564201222898901L;
    protected double m_MinRange;
    protected double m_MaxRange;
    protected int m_MaxBits;

    public String globalInfo() {
        return "Configures an " + ImagePreProcessingScaler.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-range", "minRange", (Object)0.0);
        this.m_OptionManager.add("max-range", "maxRange", (Object)1.0);
        this.m_OptionManager.add("max-bits", "maxBits", (Object)8, (Number)1, null);
    }

    public void setMinRange(double value) {
        if (this.getOptionManager().isValid("minRange", (Number)value)) {
            this.m_MinRange = value;
            this.reset();
        }
    }

    public double getMinRange() {
        return this.m_MinRange;
    }

    public String minRangeTipText() {
        return "The minimum range.";
    }

    public void setMaxRange(double value) {
        if (this.getOptionManager().isValid("maxRange", (Number)value)) {
            this.m_MaxRange = value;
            this.reset();
        }
    }

    public double getMaxRange() {
        return this.m_MaxRange;
    }

    public String maxRangeTipText() {
        return "The maximum range.";
    }

    public void setMaxBits(int value) {
        if (this.getOptionManager().isValid("maxBits", (Number)value)) {
            this.m_MaxBits = value;
            this.reset();
        }
    }

    public int getMaxBits() {
        return this.m_MaxBits;
    }

    public String maxBitsTipText() {
        return "The maximum number of bits.";
    }

    @Override
    protected DataSetPreProcessor doConfigurePreProcessor() {
        return new ImagePreProcessingScaler(this.m_MinRange, this.m_MaxRange, this.m_MaxBits);
    }
}

