/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.inputsplit;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.inputsplit.AbstractScriptedInputSplit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.WritableType;

public class ScriptedInputSplit
extends AbstractScriptedInputSplit {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient InputSplit m_InputSplitObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta input split that uses any scripting handler for managing the input split in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(InputSplit.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_InputSplitObject = (InputSplit)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_InputSplitObject = null;
    }

    protected synchronized InputSplit getInputSplit() {
        if (this.m_InputSplitObject != null) {
            return this.m_InputSplitObject;
        }
        throw new IllegalStateException("No input split script loaded!");
    }

    public long length() {
        return this.getInputSplit().length();
    }

    public URI[] locations() {
        return this.getInputSplit().locations();
    }

    public Iterator<URI> locationsIterator() {
        return Collections.emptyIterator();
    }

    public Iterator<String> locationsPathIterator() {
        return Collections.emptyIterator();
    }

    public void write(DataOutput out) throws IOException {
        this.getInputSplit().write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.getInputSplit().readFields(in);
    }

    public void writeType(DataOutput out) throws IOException {
        this.getInputSplit().writeType(out);
    }

    public double toDouble() {
        return this.getInputSplit().toDouble();
    }

    public float toFloat() {
        return this.getInputSplit().toFloat();
    }

    public int toInt() {
        return this.getInputSplit().toInt();
    }

    public long toLong() {
        return this.getInputSplit().toLong();
    }

    public WritableType getType() {
        return this.getInputSplit().getType();
    }
}

