/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.iterationlistener;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.ml.dl4j.iterationlistener.AbstractIteratorListenerConfigurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;

public class CallableActorScoreListenerConfigurator
extends AbstractIteratorListenerConfigurator {
    private static final long serialVersionUID = -3325744412079265328L;
    protected int m_Frequency;
    protected CallableActorReference m_CallableName;
    protected Actor m_CallableActor;
    protected boolean m_Optional;
    protected CallableActorHelper m_Helper;

    public String globalInfo() {
        return "Configures a score iteration listener that forwards the iteration/score pair (as Double array) to the specified callable actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("callable", "callableName", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("optional", "optional", (Object)false);
        this.m_OptionManager.add("frequency", "frequency", (Object)10, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setCallableName(CallableActorReference value) {
        this.m_CallableName = value;
        this.reset();
    }

    public CallableActorReference getCallableName() {
        return this.m_CallableName;
    }

    public String callableNameTipText() {
        return "The name of the callable actor to use.";
    }

    public void setOptional(boolean value) {
        this.m_Optional = value;
        this.reset();
    }

    public boolean getOptional() {
        return this.m_Optional;
    }

    public String optionalTipText() {
        return "If enabled, then the callable actor is optional, ie no error is raised if not found, merely ignored.";
    }

    public void setFrequency(int value) {
        if (this.getOptionManager().isValid("frequency", (Number)value)) {
            this.m_Frequency = value;
            this.reset();
        }
    }

    public int getFrequency() {
        return this.m_Frequency;
    }

    public String frequencyTipText() {
        return "The update frequency.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"callableName", (Object)this.m_CallableName);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optional", (boolean)this.m_Optional, (String)"optional", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"frequency", (Object)this.m_Frequency, (String)", frequency: ");
        return result;
    }

    @Override
    public boolean requiresFlowContext() {
        return !this.m_Optional;
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive(this.m_FlowContext, this.getCallableName());
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_CallableActor = this.findCallableActor();
            if (this.m_CallableActor == null && !this.m_Optional) {
                result = "Callable actor not found: " + this.m_CallableName;
            } else if (this.m_CallableActor != null && !(this.m_CallableActor instanceof InputConsumer)) {
                result = "Callable actor does not accept input: " + this.m_CallableActor;
            }
        }
        return result;
    }

    @Override
    protected List<IterationListener> doConfigureIterationListeners() {
        IterationListener listener = new IterationListener(){
            private static final long serialVersionUID = -6077509026351995338L;
            private int frequency;
            private boolean invoked;
            private long iterCount;
            {
                this.frequency = CallableActorScoreListenerConfigurator.this.m_Frequency;
                this.invoked = false;
                this.iterCount = 0L;
            }

            public boolean invoked() {
                return this.invoked;
            }

            public void invoke() {
                this.invoked = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void iterationDone(Model model, int iteration) {
                if (this.frequency <= 0) {
                    this.frequency = 1;
                }
                if (this.iterCount % (long)this.frequency == 0L) {
                    this.invoke();
                    double result = model.score();
                    if (CallableActorScoreListenerConfigurator.this.m_CallableActor != null) {
                        Actor actor = CallableActorScoreListenerConfigurator.this.m_CallableActor;
                        synchronized (actor) {
                            ((InputConsumer)CallableActorScoreListenerConfigurator.this.m_CallableActor).input(new Token((Object)new Double[]{this.iterCount, result}));
                            CallableActorScoreListenerConfigurator.this.m_CallableActor.execute();
                        }
                    } else {
                        CallableActorScoreListenerConfigurator.this.m_FlowContext.getLogger().info("Iteration " + this.iterCount + ". score=" + result);
                    }
                }
                ++this.iterCount;
            }
        };
        return new ArrayList<IterationListener>(Arrays.asList(listener));
    }
}

