/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.iterationlistener;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.ml.dl4j.iterationlistener.AbstractIteratorListenerConfigurator;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.optimize.listeners.ScoreIterationListener;

public class ScoreIterationListenerConfigurator
extends AbstractIteratorListenerConfigurator {
    private static final long serialVersionUID = -3325744412079265328L;
    protected int m_Frequency;

    public String globalInfo() {
        return "Configures a simple score iteration listener";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("frequency", "frequency", (Object)10, (Number)1, null);
    }

    public void setFrequency(int value) {
        if (this.getOptionManager().isValid("frequency", (Number)value)) {
            this.m_Frequency = value;
            this.reset();
        }
    }

    public int getFrequency() {
        return this.m_Frequency;
    }

    public String frequencyTipText() {
        return "The update frequency.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"frequency", (Object)this.m_Frequency, (String)"frequency: ");
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected List<IterationListener> doConfigureIterationListeners() {
        return Arrays.asList(new ScoreIterationListener(this.m_Frequency));
    }
}

