/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.model;

import adams.core.Randomizable;
import adams.ml.dl4j.model.AbstractModelConfigurator;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class AnimalsLeNet
extends AbstractModelConfigurator
implements Randomizable {
    private static final long serialVersionUID = -4915929902612899539L;
    protected int m_NumIterations;
    protected double m_LearningRate;
    protected long m_Seed;
    protected boolean m_UseRegularization;
    protected double m_L2;
    protected Activation m_Activation;
    protected WeightInit m_WeightInit;
    protected Activation m_OutputActivation;
    protected LossFunctions.LossFunction m_OutputLossFunction;

    public String globalInfo() {
        return "Convolution lenet network for classifying animals, based on this example:\nhttps://github.com/deeplearning4j/dl4j-examples/blob/ceff9965f8ae0cd8cb5cf32f8f49894a1be511fe/dl4j-examples/src/main/java/org/deeplearning4j/examples/convolution/AnimalsClassification.java";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-iterations", "numIterations", (Object)1, (Number)1, null);
        this.m_OptionManager.add("learning-rate", "learningRate", (Object)1.0E-4, (Number)0.0, null);
        this.m_OptionManager.add("seed", "seed", (Object)6L);
        this.m_OptionManager.add("use-regularization", "useRegularization", (Object)false);
        this.m_OptionManager.add("l2", "l2", (Object)0.005, (Number)0.0, null);
        this.m_OptionManager.add("activation", "activation", (Object)Activation.RELU);
        this.m_OptionManager.add("weight-init", "weightInit", (Object)WeightInit.XAVIER);
        this.m_OptionManager.add("output-activation", "outputActivation", (Object)Activation.SOFTMAX);
        this.m_OptionManager.add("output-loss-function", "outputLossFunction", (Object)LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD);
    }

    public void setNumIterations(int value) {
        if (this.getOptionManager().isValid("numIterations", (Number)value)) {
            this.m_NumIterations = value;
            this.reset();
        }
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setLearningRate(double value) {
        if (this.getOptionManager().isValid("learningRate", (Number)value)) {
            this.m_LearningRate = value;
            this.reset();
        }
    }

    public double getLearningRate() {
        return this.m_LearningRate;
    }

    public String learningRateTipText() {
        return "The learning rate to use.";
    }

    public void setSeed(long value) {
        if (this.getOptionManager().isValid("seed", (Number)value)) {
            this.m_Seed = value;
            this.reset();
        }
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the weight initialization.";
    }

    public void setUseRegularization(boolean value) {
        this.m_UseRegularization = value;
        this.reset();
    }

    public boolean getUseRegularization() {
        return this.m_UseRegularization;
    }

    public String useRegularizationTipText() {
        return "If enabled, regularization is used.";
    }

    public void setL2(double value) {
        if (this.getOptionManager().isValid("l2", (Number)value)) {
            this.m_L2 = value;
            this.reset();
        }
    }

    public double getL2() {
        return this.m_L2;
    }

    public String l2TipText() {
        return "The L2 value.";
    }

    public void setActivation(Activation value) {
        this.m_Activation = value;
        this.reset();
    }

    public Activation getActivation() {
        return this.m_Activation;
    }

    public String activationTipText() {
        return "The activation to use.";
    }

    public void setWeightInit(WeightInit value) {
        this.m_WeightInit = value;
        this.reset();
    }

    public WeightInit getWeightInit() {
        return this.m_WeightInit;
    }

    public String weightInitTipText() {
        return "The weight init to use.";
    }

    public void setOutputActivation(Activation value) {
        this.m_OutputActivation = value;
        this.reset();
    }

    public Activation getOutputActivation() {
        return this.m_OutputActivation;
    }

    public String outputActivationTipText() {
        return "The activation to use for the output layer.";
    }

    public void setOutputLossFunction(LossFunctions.LossFunction value) {
        this.m_OutputLossFunction = value;
        this.reset();
    }

    public LossFunctions.LossFunction getOutputLossFunction() {
        return this.m_OutputLossFunction;
    }

    public String outputLossFunctionTipText() {
        return "The loss function to use for the output layer.";
    }

    protected ConvolutionLayer convInit(String name, int in, int out, int[] kernel, int[] stride, int[] pad, double bias) {
        return new ConvolutionLayer.Builder(kernel, stride, pad).name(name).nIn(in).nOut(out).biasInit(bias).build();
    }

    protected ConvolutionLayer conv5x5(String name, int out, int[] stride, int[] pad, double bias) {
        return new ConvolutionLayer.Builder(new int[]{5, 5}, stride, pad).name(name).nOut(out).biasInit(bias).build();
    }

    protected SubsamplingLayer maxPool(String name, int[] kernel) {
        return ((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(kernel, new int[]{2, 2}).name(name)).build();
    }

    @Override
    protected Model doConfigureModel(int numInput, int numOutput) {
        int channels = 3;
        int height = 100;
        int width = 100;
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.m_Seed).iterations(this.m_NumIterations).regularization(this.m_UseRegularization).l2(this.m_L2).activation(this.m_Activation).learningRate(this.m_LearningRate).weightInit(this.m_WeightInit).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(Updater.RMSPROP).list().layer(0, (Layer)this.convInit("cnn1", channels, 50, new int[]{5, 5}, new int[]{1, 1}, new int[]{0, 0}, 0.0)).layer(1, (Layer)this.maxPool("maxpool1", new int[]{2, 2})).layer(2, (Layer)this.conv5x5("cnn2", 100, new int[]{5, 5}, new int[]{1, 1}, 0.0)).layer(3, (Layer)this.maxPool("maxool2", new int[]{2, 2})).layer(4, (Layer)((DenseLayer.Builder)new DenseLayer.Builder().nOut(500)).build()).layer(5, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(this.m_OutputLossFunction).nOut(numOutput)).activation(this.m_OutputActivation)).build()).backprop(true).pretrain(false).setInputType(InputType.convolutional((int)height, (int)width, (int)channels)).build();
        return new MultiLayerNetwork(conf);
    }
}

