/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.model;

import adams.data.InPlaceProcessing;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.ml.dl4j.model.AbstractModelConfigurator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;

public class FromStorage
extends AbstractModelConfigurator
implements StorageUser,
InPlaceProcessing {
    private static final long serialVersionUID = -5856765502127602083L;
    protected String m_Cache;
    protected StorageName m_StorageName;
    protected boolean m_NoCopy;

    public String globalInfo() {
        return "Retrieves the model simply from storage and forwards it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", (Object)"");
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to retrieve the value from; uses the regular storage if left empty.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to retrieve.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the model is created before returning it.";
    }

    public boolean isUsingStorage() {
        return true;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && !this.m_FlowContext.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Model not available from storage: " + this.m_StorageName;
        }
        return result;
    }

    @Override
    protected Model doConfigureModel(int numInput, int numOutput) {
        Model result;
        block6: {
            result = this.m_Cache.length() == 0 ? (Model)this.m_FlowContext.getStorageHandler().getStorage().get(this.m_StorageName) : (Model)this.m_FlowContext.getStorageHandler().getStorage().get(this.m_Cache, this.m_StorageName);
            if (!this.m_NoCopy) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    if (result instanceof MultiLayerNetwork && !((MultiLayerNetwork)result).isInitCalled()) {
                        ((MultiLayerNetwork)result).init();
                    }
                    ModelSerializer.writeModel((Model)result, (OutputStream)bos, (boolean)true);
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    if (result instanceof MultiLayerNetwork) {
                        result = ModelSerializer.restoreMultiLayerNetwork((InputStream)bis);
                        break block6;
                    }
                    if (result instanceof ComputationGraph) {
                        result = ModelSerializer.restoreComputationGraph((InputStream)bis);
                        break block6;
                    }
                    throw new IllegalStateException("Unhandled model type: " + result.getClass().getName());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create copy of model!", e);
                }
            }
        }
        return result;
    }
}

