/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.model;

import adams.core.Randomizable;
import adams.ml.dl4j.model.AbstractModelConfigurator;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class SimpleMultiLayerNetwork
extends AbstractModelConfigurator
implements Randomizable {
    private static final long serialVersionUID = -4915929902612899539L;
    protected int m_NumIterations;
    protected double m_LearningRate;
    protected long m_Seed;
    protected boolean m_UseRegularization;
    protected double m_L2;
    protected int m_HiddenNodes;
    protected Activation m_Activation;
    protected WeightInit m_WeightInit;
    protected Activation m_OutputActivation;
    protected LossFunctions.LossFunction m_OutputLossFunction;

    public String globalInfo() {
        return "A simple multilayer network, adapted from the iris example:\nhttps://github.com/deeplearning4j/dl4j-examples/blob/ba219bbbdfd2b377f30559330a173ace508b1758/dl4j-examples/src/main/java/org/deeplearning4j/examples/dataExamples/CSVExample.java";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-iterations", "numIterations", (Object)1, (Number)1, null);
        this.m_OptionManager.add("learning-rate", "learningRate", (Object)0.1, (Number)0.0, null);
        this.m_OptionManager.add("seed", "seed", (Object)6L);
        this.m_OptionManager.add("use-regularization", "useRegularization", (Object)true);
        this.m_OptionManager.add("l2", "l2", (Object)1.0E-4, (Number)0.0, null);
        this.m_OptionManager.add("hidden-nodes", "hiddenNodes", (Object)3, (Number)1, null);
        this.m_OptionManager.add("activation", "activation", (Object)Activation.TANH);
        this.m_OptionManager.add("weight-init", "weightInit", (Object)WeightInit.XAVIER);
        this.m_OptionManager.add("output-activation", "outputActivation", (Object)Activation.SOFTMAX);
        this.m_OptionManager.add("output-loss-function", "outputLossFunction", (Object)LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD);
    }

    public void setNumIterations(int value) {
        if (this.getOptionManager().isValid("numIterations", (Number)value)) {
            this.m_NumIterations = value;
            this.reset();
        }
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setLearningRate(double value) {
        if (this.getOptionManager().isValid("learningRate", (Number)value)) {
            this.m_LearningRate = value;
            this.reset();
        }
    }

    public double getLearningRate() {
        return this.m_LearningRate;
    }

    public String learningRateTipText() {
        return "The learning rate to use.";
    }

    public void setSeed(long value) {
        if (this.getOptionManager().isValid("seed", (Number)value)) {
            this.m_Seed = value;
            this.reset();
        }
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the weight initialization.";
    }

    public void setUseRegularization(boolean value) {
        this.m_UseRegularization = value;
        this.reset();
    }

    public boolean getUseRegularization() {
        return this.m_UseRegularization;
    }

    public String useRegularizationTipText() {
        return "If enabled, regularization is used.";
    }

    public void setL2(double value) {
        if (this.getOptionManager().isValid("l2", (Number)value)) {
            this.m_L2 = value;
            this.reset();
        }
    }

    public double getL2() {
        return this.m_L2;
    }

    public String l2TipText() {
        return "The L2 value.";
    }

    public void setHiddenNodes(int value) {
        this.m_HiddenNodes = value;
        this.reset();
    }

    public int getHiddenNodes() {
        return this.m_HiddenNodes;
    }

    public String hiddenNodesTipText() {
        return "The number of hidden nodes.";
    }

    public void setActivation(Activation value) {
        this.m_Activation = value;
        this.reset();
    }

    public Activation getActivation() {
        return this.m_Activation;
    }

    public String activationTipText() {
        return "The activation to use.";
    }

    public void setWeightInit(WeightInit value) {
        this.m_WeightInit = value;
        this.reset();
    }

    public WeightInit getWeightInit() {
        return this.m_WeightInit;
    }

    public String weightInitTipText() {
        return "The weight init to use.";
    }

    public void setOutputActivation(Activation value) {
        this.m_OutputActivation = value;
        this.reset();
    }

    public Activation getOutputActivation() {
        return this.m_OutputActivation;
    }

    public String outputActivationTipText() {
        return "The activation to use for the output layer.";
    }

    public void setOutputLossFunction(LossFunctions.LossFunction value) {
        this.m_OutputLossFunction = value;
        this.reset();
    }

    public LossFunctions.LossFunction getOutputLossFunction() {
        return this.m_OutputLossFunction;
    }

    public String outputLossFunctionTipText() {
        return "The loss function to use for the output layer.";
    }

    @Override
    protected Model doConfigureModel(int numInput, int numOutput) {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.m_Seed).iterations(this.m_NumIterations).activation(this.m_Activation).weightInit(this.m_WeightInit).learningRate(this.m_LearningRate).regularization(this.m_UseRegularization).l2(this.m_L2).list().layer(0, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().nIn(numInput)).nOut(this.m_HiddenNodes)).build()).layer(1, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().nIn(this.m_HiddenNodes)).nOut(this.m_HiddenNodes)).build()).layer(2, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(this.m_OutputLossFunction).activation(this.m_OutputActivation)).nIn(this.m_HiddenNodes)).nOut(numOutput)).build()).backprop(true).pretrain(false).build();
        return new MultiLayerNetwork(conf);
    }
}

