/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.modelgenerator;

import adams.ml.dl4j.modelgenerator.AbstractModelGenerator;
import adams.ml.dl4j.modelgenerator.ModelGenerator;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.nn.api.Model;

public class MultiGenerator
extends AbstractModelGenerator {
    private static final long serialVersionUID = -901928613388638637L;
    protected ModelGenerator[] m_Generators;

    public String globalInfo() {
        return "Combines the list of models generated by the specified generators.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generators", (Object)new ModelGenerator[0]);
    }

    public void setGenerators(ModelGenerator[] value) {
        this.m_Generators = value;
        this.reset();
    }

    public ModelGenerator[] getGenerators() {
        return this.m_Generators;
    }

    public String generatorsTipText() {
        return "The model generators to combine.";
    }

    @Override
    protected List<Model> doGenerate(int numInput, int numOutput) {
        ArrayList<Model> result = new ArrayList<Model>();
        for (int i = 0; i < this.m_Generators.length; ++i) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Generator #" + (i + 1) + "...");
            }
            this.m_Generators[i].setFlowContext(this.getFlowContext());
            result.addAll(this.m_Generators[i].generate(numInput, numOutput));
        }
        return result;
    }
}

