/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.ml.dl4j.recordreader.AbstractRecordReaderConfigurator;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.reader.impl.csv.CSVRecordReader;

public class CSVRecordReaderConfigurator
extends AbstractRecordReaderConfigurator {
    private static final long serialVersionUID = 8914456080710417165L;
    protected int m_SkipNumLines;
    protected String m_Delimiter;

    public String globalInfo() {
        return "Configures a " + CSVRecordReader.class.getName() + " instance.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip-num-lines", "skipNumLines", (Object)0, (Number)0, null);
        this.m_OptionManager.add("delimiter", "delimiter", (Object)",");
    }

    public void setSkipNumLines(int value) {
        if (this.getOptionManager().isValid("skipNumLines", (Number)value)) {
            this.m_SkipNumLines = value;
            this.reset();
        }
    }

    public int getSkipNumLines() {
        return this.m_SkipNumLines;
    }

    public String skipNumLinesTipText() {
        return "The number of lines to skip.";
    }

    public void setDelimiter(String value) {
        this.m_Delimiter = value;
        this.reset();
    }

    public String getDelimiter() {
        return this.m_Delimiter;
    }

    public String delimiterTipText() {
        return "The column delimiter to use.";
    }

    @Override
    protected RecordReader doConfigureRecordReader() {
        return new CSVRecordReader(this.m_SkipNumLines, this.m_Delimiter);
    }
}

