/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.ml.dl4j.recordreader.AbstractScriptedRecordReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Writable;

public class ScriptedRecordReader
extends AbstractScriptedRecordReader {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient RecordReader m_RecordReaderObject;
    protected AbstractScriptingHandler m_Handler;

    public String globalInfo() {
        return "A meta record reader that uses any scripting handler for managing the record reader in the specified script file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", (Object)new Dummy());
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(RecordReader.class, this.m_ScriptFile, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        return null;
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null) {
            this.m_RecordReaderObject = (RecordReader)this.m_ScriptObject;
        }
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_RecordReaderObject = null;
    }

    protected synchronized RecordReader getRecordReader() {
        if (this.m_RecordReaderObject != null) {
            return this.m_RecordReaderObject;
        }
        throw new IllegalStateException("No record reader script loaded!");
    }

    public void close() throws IOException {
        this.getRecordReader().close();
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.getRecordReader().initialize(split);
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.getRecordReader().initialize(conf, split);
    }

    public boolean batchesSupported() {
        return this.getRecordReader().batchesSupported();
    }

    public List<Writable> next(int num) {
        return this.getRecordReader().next(num);
    }

    public List<Writable> next() {
        return this.getRecordReader().next();
    }

    public boolean hasNext() {
        return this.getRecordReader().hasNext();
    }

    public List<String> getLabels() {
        return this.getRecordReader().getLabels();
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.getRecordReader().record(uri, dataInputStream);
    }

    public Record nextRecord() {
        return this.getRecordReader().nextRecord();
    }

    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.getRecordReader().loadFromMetaData(recordMetaData);
    }

    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return this.getRecordReader().loadFromMetaData(recordMetaDatas);
    }

    public List<RecordListener> getListeners() {
        return this.getRecordReader().getListeners();
    }

    public void setListeners(RecordListener ... recordListeners) {
        this.getRecordReader().setListeners(recordListeners);
    }

    public void setListeners(Collection<RecordListener> collection) {
        this.getRecordReader().setListeners(collection);
    }

    public void setConf(Configuration conf) {
        this.getRecordReader().setConf(conf);
    }

    public Configuration getConf() {
        return this.getRecordReader().getConf();
    }
}

