/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.SharedStringsTable;
import adams.data.conversion.SpreadSheetToNumeric;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.impl.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataLine;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class SpreadSheetRecordReader
extends BaseRecordReader {
    private static final long serialVersionUID = -837128486046274089L;
    public static final String READER_CMDLINE = "ReaderCmdLine";
    public static final String CONVERSION_CMDLINE = "ConversionCmdLine";
    protected Configuration m_Configuration;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetToNumeric m_Conversion;
    protected URI[] m_Locations;
    protected InputSplit m_InputSplit;
    protected SpreadSheet m_Sheet;
    protected int m_Row;
    protected int m_SplitIndex;

    public SpreadSheetRecordReader(SpreadSheetReader reader, SpreadSheetToNumeric conversion) {
        this.m_Reader = reader;
        this.m_Conversion = conversion;
        this.m_SplitIndex = 0;
        this.m_Row = 0;
    }

    public void close() throws IOException {
    }

    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.m_InputSplit = split;
        this.m_Sheet = null;
        this.m_Row = 0;
        this.m_Locations = split.locations();
        this.m_Sheet = this.getSheet(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpreadSheet getSheet(int index) throws IOException {
        SpreadSheet result = null;
        if (this.m_Locations.length > index) {
            try {
                result = this.m_Reader.read(this.m_Locations[index].toURL().getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                InputStream stream = null;
                try {
                    stream = this.m_Locations[index].toURL().openStream();
                    result = this.m_Reader.read(stream);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(stream);
                    throw throwable;
                }
                FileUtils.closeQuietly((InputStream)stream);
            }
        }
        if (result != null) {
            this.m_Conversion.setInput(result);
            String msg = this.m_Conversion.convert();
            if (msg != null) {
                result = null;
                System.err.println("Failed to convert spreadsheet to numeric:\n" + msg);
            } else {
                result = (SpreadSheet)this.m_Conversion.getOutput();
            }
            this.m_Conversion.cleanUp();
        }
        return result;
    }

    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        try {
            this.m_Reader = (SpreadSheetReader)OptionUtils.forCommandLine(SpreadSheetReader.class, (String)conf.get(READER_CMDLINE, new CsvSpreadSheetReader().toCommandLine()));
        }
        catch (Exception e) {
            this.m_Reader = new CsvSpreadSheetReader();
        }
        try {
            this.m_Conversion = (SpreadSheetToNumeric)OptionUtils.forCommandLine(SpreadSheetToNumeric.class, (String)conf.get(CONVERSION_CMDLINE, new SpreadSheetToNumeric().toCommandLine()));
        }
        catch (Exception e) {
            this.m_Conversion = new SpreadSheetToNumeric();
        }
    }

    public List<Writable> next() {
        ArrayList<Object> cells = null;
        if (this.m_Row >= this.m_Sheet.getRowCount()) {
            this.m_Sheet = null;
            this.m_Row = 0;
            if (this.m_SplitIndex < this.m_Locations.length - 1) {
                ++this.m_SplitIndex;
            } else {
                return null;
            }
            try {
                this.m_Sheet = this.getSheet(this.m_SplitIndex);
            }
            catch (Exception e) {
                this.m_Sheet = null;
            }
        }
        if (this.m_Sheet != null) {
            SharedStringsTable table = this.m_Sheet.getSharedStringsTable();
            cells = new ArrayList<Object>();
            DataRow row = this.m_Sheet.getRow(this.m_Row);
            block10: for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                if (!row.hasCell(i)) {
                    cells.add(new DoubleWritable(Double.NaN));
                    continue;
                }
                Cell cell = row.getCell(i);
                switch (cell.getContentType()) {
                    case MISSING: {
                        cells.add(new DoubleWritable(Double.NaN));
                        continue block10;
                    }
                    case LONG: {
                        cells.add(new LongWritable(cell.toLong().longValue()));
                        continue block10;
                    }
                    case DOUBLE: {
                        cells.add(new DoubleWritable(cell.toDouble().doubleValue()));
                        continue block10;
                    }
                    case BOOLEAN: {
                        cells.add(new IntWritable(cell.toBoolean() != false ? 1 : 0));
                        continue block10;
                    }
                    case DATE: 
                    case DATETIME: 
                    case DATETIMEMSEC: 
                    case TIME: 
                    case TIMEMSEC: {
                        cells.add(new LongWritable(cell.toAnyDateType().getTime()));
                        continue block10;
                    }
                    case STRING: {
                        cells.add(new IntWritable(table.getIndex(cell.getContent())));
                        continue block10;
                    }
                    default: {
                        cells.add(new DoubleWritable(Double.NaN));
                    }
                }
            }
            ++this.m_Row;
        }
        return cells;
    }

    public boolean hasNext() {
        return this.m_Sheet != null && this.m_Row < this.m_Sheet.getRowCount() || this.m_Locations != null && this.m_SplitIndex < this.m_Locations.length - 1;
    }

    public List<String> getLabels() {
        return null;
    }

    public void reset() {
        if (this.m_InputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.initialize(this.m_InputSplit);
            this.m_SplitIndex = 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Error during spreadsheet record reader reset", e);
        }
    }

    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return null;
    }

    public org.datavec.api.records.Record nextRecord() {
        List<Writable> next = this.next();
        URI uri = this.m_Locations == null || this.m_Locations.length < 1 ? null : this.m_Locations[this.m_SplitIndex];
        RecordMetaDataLine meta = new RecordMetaDataLine(this.m_Row - 1, uri, SpreadSheetRecordReader.class);
        return new Record(next, (RecordMetaData)meta);
    }

    public org.datavec.api.records.Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return null;
    }

    public List<org.datavec.api.records.Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return null;
    }

    public void setConf(Configuration conf) {
        this.m_Configuration = conf;
    }

    public Configuration getConf() {
        return this.m_Configuration;
    }
}

