/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.recordreader;

import adams.data.conversion.SpreadSheetToNumeric;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.ml.dl4j.recordreader.AbstractRecordReaderConfigurator;
import adams.ml.dl4j.recordreader.SpreadSheetRecordReader;
import org.datavec.api.records.reader.RecordReader;

public class SpreadSheetRecordReaderConfigurator
extends AbstractRecordReaderConfigurator {
    private static final long serialVersionUID = 8914456080710417165L;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetToNumeric m_Conversion;

    public String globalInfo() {
        return "Allows reading of spreadsheets supported by ADAMS.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", (Object)new CsvSpreadSheetReader());
        this.m_OptionManager.add("conversion", "conversion", (Object)new SpreadSheetToNumeric());
    }

    public void setReader(SpreadSheetReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The spreadsheet reader to use.";
    }

    public void setConversion(SpreadSheetToNumeric value) {
        this.m_Conversion = value;
        this.reset();
    }

    public SpreadSheetToNumeric getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion setup to use for converting non-numeric cells into numeric ones.";
    }

    @Override
    protected RecordReader doConfigureRecordReader() {
        return new SpreadSheetRecordReader(this.m_Reader, this.m_Conversion);
    }
}

