/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.MessageCollection;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.flow.container.DL4JModelContainer;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;

public abstract class AbstractTrainStopCriterion
extends AbstractOptionHandler
implements FlowContextHandler,
QuickInfoSupporter {
    private static final long serialVersionUID = 3803261952968636827L;
    protected Actor m_FlowContext;
    protected String m_Name;

    protected void reset() {
        super.reset();
        this.start();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("name", "name", (Object)"");
    }

    public void setName(String value) {
        this.m_Name = value;
        this.reset();
    }

    public String getName() {
        return this.m_Name;
    }

    public String nameTipText() {
        return "The (optional) name for the criterion, which is used in the trigger messages; can be used to create unique name.";
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public abstract boolean requiresFlowContext();

    public String getQuickInfo() {
        return null;
    }

    public void start() {
    }

    protected String check(DL4JModelContainer cont) {
        if (this.requiresFlowContext() && this.m_FlowContext == null) {
            return "No flow context set!";
        }
        return null;
    }

    protected void addTriggerMessage(MessageCollection triggers) {
        String name = this.m_Name.isEmpty() ? "unnamed" : this.m_Name;
        triggers.add(name + ": " + this.toCommandLine());
    }

    protected abstract boolean doCheckStopping(DL4JModelContainer var1, MessageCollection var2);

    public boolean checkStopping(DL4JModelContainer cont, MessageCollection triggers) {
        String msg = this.check(cont);
        if (msg != null) {
            this.getLogger().warning(msg);
            return false;
        }
        boolean result = this.doCheckStopping(cont, triggers);
        if (result) {
            this.addTriggerMessage(triggers);
        }
        return result;
    }
}

