/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.MessageCollection;
import adams.flow.container.DL4JModelContainer;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterionEnhancer;
import adams.ml.dl4j.trainstopcriterion.MaxEpoch;
import adams.ml.dl4j.trainstopcriterion.Statistic;

public class DelayedCriterion
extends AbstractTrainStopCriterionEnhancer {
    private static final long serialVersionUID = 6975594226423139162L;
    protected AbstractTrainStopCriterion m_DelayCriterion;
    protected boolean m_Triggered;

    public String globalInfo() {
        return "The base criterion only gets applied after the delay criterion triggered.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("delay-criterion", "delayCriterion", (Object)new MaxEpoch());
    }

    @Override
    protected AbstractTrainStopCriterion getDefaultBaseCriterion() {
        return new Statistic();
    }

    @Override
    public String baseCriterionTipText() {
        return "The criterion to apply once the delay one has triggered.";
    }

    public void setDelayCriterion(AbstractTrainStopCriterion value) {
        this.m_DelayCriterion = value;
        this.reset();
    }

    public AbstractTrainStopCriterion getDelayCriterion() {
        return this.m_DelayCriterion;
    }

    public String delayCriterionTipText() {
        return "The criterion that determines the delay, ie once this criterion has triggered, the base criterion gets applied; eg " + MaxEpoch.class.getName() + " is used to execute a number iterations before checking whether a certain statistic goes up again using " + Statistic.class.getName() + ".";
    }

    @Override
    public boolean requiresFlowContext() {
        return super.requiresFlowContext() || this.m_DelayCriterion.requiresFlowContext();
    }

    @Override
    public void start() {
        super.start();
        this.m_Triggered = false;
        if (this.m_DelayCriterion != null) {
            this.m_DelayCriterion.start();
        }
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        boolean result = false;
        if (!this.m_Triggered) {
            this.m_Triggered = this.m_DelayCriterion.checkStopping(cont, new MessageCollection());
            if (this.m_Triggered && this.isLoggingEnabled()) {
                this.getLogger().info("Delay criterion triggered: " + (Object)((Object)this.m_DelayCriterion));
            }
        }
        if (this.m_Triggered) {
            result = this.m_BaseCriterion.checkStopping(cont, triggers);
        }
        return result;
    }
}

