/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.MessageCollection;
import adams.flow.container.DL4JModelContainer;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;

public class MaxEpoch
extends AbstractTrainStopCriterion {
    private static final long serialVersionUID = 6975594226423139162L;
    protected int m_NumEpochs;
    protected int m_Epoch;

    public String globalInfo() {
        return "Allows only a pre-defined number of epochs.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-epochs", "numEpochs", (Object)1000, (Number)1, null);
    }

    public void setNumEpochs(int value) {
        this.m_NumEpochs = value;
        this.reset();
    }

    public int getNumEpochs() {
        return this.m_NumEpochs;
    }

    public String numEpochsTipText() {
        return "The number of epochs to perform.";
    }

    @Override
    public void start() {
        super.start();
        this.m_Epoch = 0;
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        ++this.m_Epoch;
        return this.m_Epoch >= this.m_NumEpochs;
    }
}

