/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.MessageCollection;
import adams.flow.container.DL4JModelContainer;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;

public class MaxTime
extends AbstractTrainStopCriterion {
    private static final long serialVersionUID = 6975594226423139162L;
    protected int m_MaxSeconds;
    protected long m_Start;

    public String globalInfo() {
        return "Defines a maximum number of seconds for training.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("max-seconds", "maxSeconds", (Object)1000, (Number)1, null);
    }

    public void setMaxSeconds(int value) {
        this.m_MaxSeconds = value;
        this.reset();
    }

    public int getMaxSeconds() {
        return this.m_MaxSeconds;
    }

    public String maxSecondsTipText() {
        return "The maximum number of seconds to train.";
    }

    @Override
    public void start() {
        super.start();
        this.m_Start = System.currentTimeMillis();
    }

    @Override
    public boolean requiresFlowContext() {
        return false;
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        return System.currentTimeMillis() >= this.m_Start + (long)(this.m_MaxSeconds * 1000);
    }
}

