/*
 * Decompiled with CFR 0.152.
 */
package adams.ml.dl4j.trainstopcriterion;

import adams.core.MessageCollection;
import adams.flow.container.DL4JModelContainer;
import adams.flow.core.Actor;
import adams.ml.dl4j.trainstopcriterion.AbstractTrainStopCriterion;

public class MultiStopCriterion
extends AbstractTrainStopCriterion {
    private static final long serialVersionUID = 6975594226423139162L;
    protected AbstractTrainStopCriterion[] m_Criteria;
    protected CombinationType m_CombinationType;

    public String globalInfo() {
        return "Applies the specified criteria sequentially, combining the results according to the specified combination type.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("criterion", "criteria", (Object)new AbstractTrainStopCriterion[0]);
        this.m_OptionManager.add("combination-type", "combinationType", (Object)CombinationType.OR);
    }

    public void setCriteria(AbstractTrainStopCriterion[] value) {
        this.m_Criteria = value;
        this.reset();
        this.setFlowContext(this.getFlowContext());
    }

    public AbstractTrainStopCriterion[] getCriteria() {
        return this.m_Criteria;
    }

    public String criteriaTipText() {
        return "The criteria to apply and combine.";
    }

    public void setCombinationType(CombinationType value) {
        this.m_CombinationType = value;
        this.reset();
    }

    public CombinationType getCombinationType() {
        return this.m_CombinationType;
    }

    public String combinationTypeTipText() {
        return "How to combine the results of the criteria.";
    }

    @Override
    public void setFlowContext(Actor value) {
        super.setFlowContext(value);
        for (AbstractTrainStopCriterion c : this.m_Criteria) {
            c.setFlowContext(value);
        }
    }

    @Override
    public boolean requiresFlowContext() {
        boolean result = false;
        for (AbstractTrainStopCriterion c : this.m_Criteria) {
            result = result || c.requiresFlowContext();
        }
        return result;
    }

    @Override
    public void start() {
        super.start();
        if (this.m_Criteria != null) {
            for (AbstractTrainStopCriterion criterion : this.m_Criteria) {
                criterion.start();
            }
        }
    }

    @Override
    protected boolean doCheckStopping(DL4JModelContainer cont, MessageCollection triggers) {
        boolean result = false;
        block4: for (int i = 0; i < this.m_Criteria.length; ++i) {
            boolean sub = this.m_Criteria[i].checkStopping(cont, triggers);
            if (i == 0) {
                result = sub;
                continue;
            }
            switch (this.m_CombinationType) {
                case AND: {
                    result = result && sub;
                    continue block4;
                }
                case OR: {
                    result = result || sub;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled combination type: " + (Object)((Object)this.m_CombinationType));
                }
            }
        }
        return result;
    }

    public static enum CombinationType {
        AND,
        OR;

    }
}

